<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessActivityAnalyticsScheduleInfo StructType
 * @subpackage Structs
 */
class BusinessActivityAnalyticsScheduleInfo extends AbstractStructBase
{
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowId;
    /**
     * The RuleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RuleType;
    /**
     * The ScheduleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduleDescription;
    /**
     * The PersonCountThresholds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $PersonCountThresholds;
    /**
     * The WaitTimeThresholds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfFloat
     */
    public $WaitTimeThresholds;
    /**
     * Constructor method for BusinessActivityAnalyticsScheduleInfo
     * @uses BusinessActivityAnalyticsScheduleInfo::setRowId()
     * @uses BusinessActivityAnalyticsScheduleInfo::setRuleType()
     * @uses BusinessActivityAnalyticsScheduleInfo::setScheduleDescription()
     * @uses BusinessActivityAnalyticsScheduleInfo::setPersonCountThresholds()
     * @uses BusinessActivityAnalyticsScheduleInfo::setWaitTimeThresholds()
     * @param int $rowId
     * @param string $ruleType
     * @param string $scheduleDescription
     * @param \CustomerManagement\ArrayType\ArrayOfInt $personCountThresholds
     * @param \CustomerManagement\ArrayType\ArrayOfFloat $waitTimeThresholds
     */
    public function __construct($rowId = null, $ruleType = null, $scheduleDescription = null, \CustomerManagement\ArrayType\ArrayOfInt $personCountThresholds = null, \CustomerManagement\ArrayType\ArrayOfFloat $waitTimeThresholds = null)
    {
        $this
            ->setRowId($rowId)
            ->setRuleType($ruleType)
            ->setScheduleDescription($scheduleDescription)
            ->setPersonCountThresholds($personCountThresholds)
            ->setWaitTimeThresholds($waitTimeThresholds);
    }
    /**
     * Get RowId value
     * @return int
     */
    public function getRowId()
    {
        return $this->RowId;
    }
    /**
     * Set RowId value
     * @param int $rowId
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        $this->RowId = $rowId;
        return $this;
    }
    /**
     * Get RuleType value
     * @return string
     */
    public function getRuleType()
    {
        return $this->RuleType;
    }
    /**
     * Set RuleType value
     * @uses \CustomerManagement\EnumType\OvlRuleTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\OvlRuleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ruleType
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\OvlRuleTypeEnum::valueIsValid($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\OvlRuleTypeEnum', is_array($ruleType) ? implode(', ', $ruleType) : var_export($ruleType, true), implode(', ', \CustomerManagement\EnumType\OvlRuleTypeEnum::getValidValues())), __LINE__);
        }
        $this->RuleType = $ruleType;
        return $this;
    }
    /**
     * Get ScheduleDescription value
     * @return string|null
     */
    public function getScheduleDescription()
    {
        return $this->ScheduleDescription;
    }
    /**
     * Set ScheduleDescription value
     * @param string $scheduleDescription
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo
     */
    public function setScheduleDescription($scheduleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleDescription) && !is_string($scheduleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleDescription, true), gettype($scheduleDescription)), __LINE__);
        }
        $this->ScheduleDescription = $scheduleDescription;
        return $this;
    }
    /**
     * Get PersonCountThresholds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getPersonCountThresholds()
    {
        return $this->PersonCountThresholds;
    }
    /**
     * Set PersonCountThresholds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $personCountThresholds
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo
     */
    public function setPersonCountThresholds(\CustomerManagement\ArrayType\ArrayOfInt $personCountThresholds = null)
    {
        $this->PersonCountThresholds = $personCountThresholds;
        return $this;
    }
    /**
     * Get WaitTimeThresholds value
     * @return \CustomerManagement\ArrayType\ArrayOfFloat|null
     */
    public function getWaitTimeThresholds()
    {
        return $this->WaitTimeThresholds;
    }
    /**
     * Set WaitTimeThresholds value
     * @param \CustomerManagement\ArrayType\ArrayOfFloat $waitTimeThresholds
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo
     */
    public function setWaitTimeThresholds(\CustomerManagement\ArrayType\ArrayOfFloat $waitTimeThresholds = null)
    {
        $this->WaitTimeThresholds = $waitTimeThresholds;
        return $this;
    }
}
