<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivateInstantaneousModeInput StructType
 * @subpackage Structs
 */
class ActivateInstantaneousModeInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ActiveUntil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ActiveUntil;
    /**
     * Constructor method for ActivateInstantaneousModeInput
     * @uses ActivateInstantaneousModeInput::setCustomerId()
     * @uses ActivateInstantaneousModeInput::setActiveUntil()
     * @param int $customerId
     * @param string $activeUntil
     */
    public function __construct($customerId = null, $activeUntil = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setActiveUntil($activeUntil);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ActivateInstantaneousModeInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ActiveUntil value
     * @return string
     */
    public function getActiveUntil()
    {
        return $this->ActiveUntil;
    }
    /**
     * Set ActiveUntil value
     * @param string $activeUntil
     * @return \CustomerManagement\StructType\ActivateInstantaneousModeInput
     */
    public function setActiveUntil($activeUntil = null)
    {
        // validation for constraint: string
        if (!is_null($activeUntil) && !is_string($activeUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeUntil, true), gettype($activeUntil)), __LINE__);
        }
        $this->ActiveUntil = $activeUntil;
        return $this;
    }
}
