<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateNxSensorTypeInput StructType
 * @subpackage Structs
 */
class UpdateNxSensorTypeInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The NxSensorType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NxSensorType;
    /**
     * Constructor method for UpdateNxSensorTypeInput
     * @uses UpdateNxSensorTypeInput::setCustomerId()
     * @uses UpdateNxSensorTypeInput::setSensorId()
     * @uses UpdateNxSensorTypeInput::setNxSensorType()
     * @param int $customerId
     * @param int $sensorId
     * @param int $nxSensorType
     */
    public function __construct($customerId = null, $sensorId = null, $nxSensorType = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setNxSensorType($nxSensorType);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateNxSensorTypeInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\UpdateNxSensorTypeInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get NxSensorType value
     * @return int
     */
    public function getNxSensorType()
    {
        return $this->NxSensorType;
    }
    /**
     * Set NxSensorType value
     * @param int $nxSensorType
     * @return \CustomerManagement\StructType\UpdateNxSensorTypeInput
     */
    public function setNxSensorType($nxSensorType = null)
    {
        // validation for constraint: int
        if (!is_null($nxSensorType) && !(is_int($nxSensorType) || ctype_digit($nxSensorType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nxSensorType, true), gettype($nxSensorType)), __LINE__);
        }
        $this->NxSensorType = $nxSensorType;
        return $this;
    }
}
