<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLoginPasswordWithoutPassword StructType
 * @subpackage Structs
 */
class UpdateLoginPasswordWithoutPassword extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The loginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginName;
    /**
     * The newPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newPassword;
    /**
     * Constructor method for UpdateLoginPasswordWithoutPassword
     * @uses UpdateLoginPasswordWithoutPassword::setCustomerId()
     * @uses UpdateLoginPasswordWithoutPassword::setLoginName()
     * @uses UpdateLoginPasswordWithoutPassword::setNewPassword()
     * @param int $customerId
     * @param string $loginName
     * @param string $newPassword
     */
    public function __construct($customerId = null, $loginName = null, $newPassword = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginName($loginName)
            ->setNewPassword($newPassword);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get loginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->loginName;
    }
    /**
     * Set loginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->loginName = $loginName;
        return $this;
    }
    /**
     * Get newPassword value
     * @return string|null
     */
    public function getNewPassword()
    {
        return $this->newPassword;
    }
    /**
     * Set newPassword value
     * @param string $newPassword
     * @return \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        $this->newPassword = $newPassword;
        return $this;
    }
}
