<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClockFailure StructType
 * @subpackage Structs
 */
class ClockFailure extends AbstractStructBase
{
    /**
     * The DefaultTimeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DefaultTimeUtc;
    /**
     * The ClockFaultAllowance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClockFaultAllowance;
    /**
     * The HasTroubleCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasTroubleCondition;
    /**
     * The PanelTimeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PanelTimeUtc;
    /**
     * The BackendTimeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BackendTimeUtc;
    /**
     * Constructor method for ClockFailure
     * @uses ClockFailure::setDefaultTimeUtc()
     * @uses ClockFailure::setClockFaultAllowance()
     * @uses ClockFailure::setHasTroubleCondition()
     * @uses ClockFailure::setPanelTimeUtc()
     * @uses ClockFailure::setBackendTimeUtc()
     * @param string $defaultTimeUtc
     * @param int $clockFaultAllowance
     * @param bool $hasTroubleCondition
     * @param string $panelTimeUtc
     * @param string $backendTimeUtc
     */
    public function __construct($defaultTimeUtc = null, $clockFaultAllowance = null, $hasTroubleCondition = null, $panelTimeUtc = null, $backendTimeUtc = null)
    {
        $this
            ->setDefaultTimeUtc($defaultTimeUtc)
            ->setClockFaultAllowance($clockFaultAllowance)
            ->setHasTroubleCondition($hasTroubleCondition)
            ->setPanelTimeUtc($panelTimeUtc)
            ->setBackendTimeUtc($backendTimeUtc);
    }
    /**
     * Get DefaultTimeUtc value
     * @return string
     */
    public function getDefaultTimeUtc()
    {
        return $this->DefaultTimeUtc;
    }
    /**
     * Set DefaultTimeUtc value
     * @param string $defaultTimeUtc
     * @return \CustomerManagement\StructType\ClockFailure
     */
    public function setDefaultTimeUtc($defaultTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTimeUtc) && !is_string($defaultTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTimeUtc, true), gettype($defaultTimeUtc)), __LINE__);
        }
        $this->DefaultTimeUtc = $defaultTimeUtc;
        return $this;
    }
    /**
     * Get ClockFaultAllowance value
     * @return int
     */
    public function getClockFaultAllowance()
    {
        return $this->ClockFaultAllowance;
    }
    /**
     * Set ClockFaultAllowance value
     * @param int $clockFaultAllowance
     * @return \CustomerManagement\StructType\ClockFailure
     */
    public function setClockFaultAllowance($clockFaultAllowance = null)
    {
        // validation for constraint: int
        if (!is_null($clockFaultAllowance) && !(is_int($clockFaultAllowance) || ctype_digit($clockFaultAllowance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clockFaultAllowance, true), gettype($clockFaultAllowance)), __LINE__);
        }
        $this->ClockFaultAllowance = $clockFaultAllowance;
        return $this;
    }
    /**
     * Get HasTroubleCondition value
     * @return bool
     */
    public function getHasTroubleCondition()
    {
        return $this->HasTroubleCondition;
    }
    /**
     * Set HasTroubleCondition value
     * @param bool $hasTroubleCondition
     * @return \CustomerManagement\StructType\ClockFailure
     */
    public function setHasTroubleCondition($hasTroubleCondition = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTroubleCondition) && !is_bool($hasTroubleCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTroubleCondition, true), gettype($hasTroubleCondition)), __LINE__);
        }
        $this->HasTroubleCondition = $hasTroubleCondition;
        return $this;
    }
    /**
     * Get PanelTimeUtc value
     * @return string
     */
    public function getPanelTimeUtc()
    {
        return $this->PanelTimeUtc;
    }
    /**
     * Set PanelTimeUtc value
     * @param string $panelTimeUtc
     * @return \CustomerManagement\StructType\ClockFailure
     */
    public function setPanelTimeUtc($panelTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($panelTimeUtc) && !is_string($panelTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panelTimeUtc, true), gettype($panelTimeUtc)), __LINE__);
        }
        $this->PanelTimeUtc = $panelTimeUtc;
        return $this;
    }
    /**
     * Get BackendTimeUtc value
     * @return string
     */
    public function getBackendTimeUtc()
    {
        return $this->BackendTimeUtc;
    }
    /**
     * Set BackendTimeUtc value
     * @param string $backendTimeUtc
     * @return \CustomerManagement\StructType\ClockFailure
     */
    public function setBackendTimeUtc($backendTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($backendTimeUtc) && !is_string($backendTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backendTimeUtc, true), gettype($backendTimeUtc)), __LINE__);
        }
        $this->BackendTimeUtc = $backendTimeUtc;
        return $this;
    }
}
