<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFloat ArrayType
 * @subpackage Arrays
 */
class ArrayOfFloat extends AbstractStructArrayBase
{
    /**
     * The float
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $float;
    /**
     * Constructor method for ArrayOfFloat
     * @uses ArrayOfFloat::setFloat()
     * @param float[] $float
     */
    public function __construct(array $float = array())
    {
        $this
            ->setFloat($float);
    }
    /**
     * Get float value
     * @return float[]|null
     */
    public function getFloat()
    {
        return $this->float;
    }
    /**
     * This method is responsible for validating the values passed to the setFloat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFloat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFloatForArrayConstraintsFromSetFloat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFloatFloatItem) {
            // validation for constraint: itemType
            if (!(is_float($arrayOfFloatFloatItem) || is_numeric($arrayOfFloatFloatItem))) {
                $invalidValues[] = is_object($arrayOfFloatFloatItem) ? get_class($arrayOfFloatFloatItem) : sprintf('%s(%s)', gettype($arrayOfFloatFloatItem), var_export($arrayOfFloatFloatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The float property can only contain items of type float, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set float value
     * @throws \InvalidArgumentException
     * @param float[] $float
     * @return \CustomerManagement\ArrayType\ArrayOfFloat
     */
    public function setFloat(array $float = array())
    {
        // validation for constraint: array
        if ('' !== ($floatArrayErrorMessage = self::validateFloatForArrayConstraintsFromSetFloat($float))) {
            throw new \InvalidArgumentException($floatArrayErrorMessage, __LINE__);
        }
        $this->float = $float;
        return $this;
    }
    /**
     * Add item to float value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \CustomerManagement\ArrayType\ArrayOfFloat
     */
    public function addToFloat($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The float property can only contain items of type float, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->float[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return float|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return float|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return float|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return float|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return float|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string float
     */
    public function getAttributeName()
    {
        return 'float';
    }
}
