<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBusinessActivityAnalyticsMetricInfoInput StructType
 * @subpackage Structs
 */
class GetBusinessActivityAnalyticsMetricInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowId;
    /**
     * Constructor method for GetBusinessActivityAnalyticsMetricInfoInput
     * @uses GetBusinessActivityAnalyticsMetricInfoInput::setCustomerId()
     * @uses GetBusinessActivityAnalyticsMetricInfoInput::setRowId()
     * @param int $customerId
     * @param int $rowId
     */
    public function __construct($customerId = null, $rowId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRowId($rowId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsMetricInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RowId value
     * @return int
     */
    public function getRowId()
    {
        return $this->RowId;
    }
    /**
     * Set RowId value
     * @param int $rowId
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsMetricInfoInput
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        $this->RowId = $rowId;
        return $this;
    }
}
