<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ArmingStateActionEnum EnumType
 * @subpackage Enumerations
 */
class ArmingStateActionEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Disarm'
     * @return string 'Disarm'
     */
    const VALUE_DISARM = 'Disarm';
    /**
     * Constant for value 'ArmStay'
     * @return string 'ArmStay'
     */
    const VALUE_ARM_STAY = 'ArmStay';
    /**
     * Constant for value 'ArmAway'
     * @return string 'ArmAway'
     */
    const VALUE_ARM_AWAY = 'ArmAway';
    /**
     * Constant for value 'ArmNight'
     * @return string 'ArmNight'
     */
    const VALUE_ARM_NIGHT = 'ArmNight';
    /**
     * Return allowed values
     * @uses self::VALUE_DISARM
     * @uses self::VALUE_ARM_STAY
     * @uses self::VALUE_ARM_AWAY
     * @uses self::VALUE_ARM_NIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISARM,
            self::VALUE_ARM_STAY,
            self::VALUE_ARM_AWAY,
            self::VALUE_ARM_NIGHT,
        );
    }
}
