<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessActivityAnalyticsMetricInfo StructType
 * @subpackage Structs
 */
class BusinessActivityAnalyticsMetricInfo extends AbstractStructBase
{
    /**
     * The OccupancyCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OccupancyCount;
    /**
     * The WaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WaitTime;
    /**
     * The TimestampLocal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimestampLocal;
    /**
     * Constructor method for BusinessActivityAnalyticsMetricInfo
     * @uses BusinessActivityAnalyticsMetricInfo::setOccupancyCount()
     * @uses BusinessActivityAnalyticsMetricInfo::setWaitTime()
     * @uses BusinessActivityAnalyticsMetricInfo::setTimestampLocal()
     * @param int $occupancyCount
     * @param int $waitTime
     * @param string $timestampLocal
     */
    public function __construct($occupancyCount = null, $waitTime = null, $timestampLocal = null)
    {
        $this
            ->setOccupancyCount($occupancyCount)
            ->setWaitTime($waitTime)
            ->setTimestampLocal($timestampLocal);
    }
    /**
     * Get OccupancyCount value
     * @return int
     */
    public function getOccupancyCount()
    {
        return $this->OccupancyCount;
    }
    /**
     * Set OccupancyCount value
     * @param int $occupancyCount
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setOccupancyCount($occupancyCount = null)
    {
        // validation for constraint: int
        if (!is_null($occupancyCount) && !(is_int($occupancyCount) || ctype_digit($occupancyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupancyCount, true), gettype($occupancyCount)), __LINE__);
        }
        $this->OccupancyCount = $occupancyCount;
        return $this;
    }
    /**
     * Get WaitTime value
     * @return int
     */
    public function getWaitTime()
    {
        return $this->WaitTime;
    }
    /**
     * Set WaitTime value
     * @param int $waitTime
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setWaitTime($waitTime = null)
    {
        // validation for constraint: int
        if (!is_null($waitTime) && !(is_int($waitTime) || ctype_digit($waitTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitTime, true), gettype($waitTime)), __LINE__);
        }
        $this->WaitTime = $waitTime;
        return $this;
    }
    /**
     * Get TimestampLocal value
     * @return string|null
     */
    public function getTimestampLocal()
    {
        return $this->TimestampLocal;
    }
    /**
     * Set TimestampLocal value
     * @param string $timestampLocal
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setTimestampLocal($timestampLocal = null)
    {
        // validation for constraint: string
        if (!is_null($timestampLocal) && !is_string($timestampLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampLocal, true), gettype($timestampLocal)), __LINE__);
        }
        $this->TimestampLocal = $timestampLocal;
        return $this;
    }
}
