<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelEvent operation/method
 */
if ($cancel->cancelEvent(new \StructType\CancelEvent()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateEvent operation/method
 */
if ($update->updateEvent(new \StructType\UpdateEvent()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for searchEvents operation/method
 */
if ($search->searchEvents(new \StructType\SearchEvents()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteEvents operation/method
 */
if ($delete->deleteEvents(new \StructType\DeleteEvents()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getEvents operation/method
 */
if ($get->getEvents(new \StructType\GetEvents()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Unschedule ServiceType
 */
$unschedule = new \ServiceType\Unschedule($options);
/**
 * Sample call for unscheduleEvent operation/method
 */
if ($unschedule->unscheduleEvent(new \StructType\UnscheduleEvent()) !== false) {
    print_r($unschedule->getResult());
} else {
    print_r($unschedule->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \ServiceType\Invalidate($options);
/**
 * Sample call for invalidateEvent operation/method
 */
if ($invalidate->invalidateEvent(new \StructType\InvalidateEvent()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \ServiceType\Schedule($options);
/**
 * Sample call for scheduleEvent operation/method
 */
if ($schedule->scheduleEvent(new \StructType\ScheduleEvent()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addAnnotation operation/method
 */
if ($add->addAnnotation(new \StructType\AddAnnotation()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createEvents operation/method
 */
if ($create->createEvents(new \StructType\CreateEvents()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
