<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateEvent StructType
 * Meta information extracted from the WSDL
 * - type: tns:updateEvent
 * @subpackage Structs
 */
class UpdateEvent extends AbstractStructBase
{
    /**
     * The event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessEvent
     */
    public $event;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for updateEvent
     * @uses UpdateEvent::setEvent()
     * @uses UpdateEvent::setOptions()
     * @param \StructType\BusinessEvent $event
     * @param \StructType\WsEntry[] $options
     */
    public function __construct(\StructType\BusinessEvent $event = null, array $options = array())
    {
        $this
            ->setEvent($event)
            ->setOptions($options);
    }
    /**
     * Get event value
     * @return \StructType\BusinessEvent|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @param \StructType\BusinessEvent $event
     * @return \StructType\UpdateEvent
     */
    public function setEvent(\StructType\BusinessEvent $event = null)
    {
        $this->event = $event;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateEventOptionsItem) {
            // validation for constraint: itemType
            if (!$updateEventOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($updateEventOptionsItem) ? get_class($updateEventOptionsItem) : sprintf('%s(%s)', gettype($updateEventOptionsItem), var_export($updateEventOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\UpdateEvent
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\UpdateEvent
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
