<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for schedulingData StructType
 * @subpackage Structs
 */
class SchedulingData extends AbstractStructBase
{
    /**
     * The agentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntityId
     */
    public $agentId;
    /**
     * The appointmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appointmentDate;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The schedulingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schedulingDate;
    /**
     * The schedulingEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schedulingEndDate;
    /**
     * The teamMates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $teamMates;
    /**
     * The useSchedulingHour
     * @var bool
     */
    public $useSchedulingHour;
    /**
     * Constructor method for schedulingData
     * @uses SchedulingData::setAgentId()
     * @uses SchedulingData::setAppointmentDate()
     * @uses SchedulingData::setExtensions()
     * @uses SchedulingData::setSchedulingDate()
     * @uses SchedulingData::setSchedulingEndDate()
     * @uses SchedulingData::setTeamMates()
     * @uses SchedulingData::setUseSchedulingHour()
     * @param \StructType\EntityId $agentId
     * @param string $appointmentDate
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $schedulingDate
     * @param string $schedulingEndDate
     * @param string[] $teamMates
     * @param bool $useSchedulingHour
     */
    public function __construct(\StructType\EntityId $agentId = null, $appointmentDate = null, array $extensions = array(), $schedulingDate = null, $schedulingEndDate = null, array $teamMates = array(), $useSchedulingHour = null)
    {
        $this
            ->setAgentId($agentId)
            ->setAppointmentDate($appointmentDate)
            ->setExtensions($extensions)
            ->setSchedulingDate($schedulingDate)
            ->setSchedulingEndDate($schedulingEndDate)
            ->setTeamMates($teamMates)
            ->setUseSchedulingHour($useSchedulingHour);
    }
    /**
     * Get agentId value
     * @return \StructType\EntityId|null
     */
    public function getAgentId()
    {
        return $this->agentId;
    }
    /**
     * Set agentId value
     * @param \StructType\EntityId $agentId
     * @return \StructType\SchedulingData
     */
    public function setAgentId(\StructType\EntityId $agentId = null)
    {
        $this->agentId = $agentId;
        return $this;
    }
    /**
     * Get appointmentDate value
     * @return string|null
     */
    public function getAppointmentDate()
    {
        return $this->appointmentDate;
    }
    /**
     * Set appointmentDate value
     * @param string $appointmentDate
     * @return \StructType\SchedulingData
     */
    public function setAppointmentDate($appointmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentDate) && !is_string($appointmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appointmentDate, true), gettype($appointmentDate)), __LINE__);
        }
        $this->appointmentDate = $appointmentDate;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $schedulingDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$schedulingDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($schedulingDataExtensionsItem) ? get_class($schedulingDataExtensionsItem) : sprintf('%s(%s)', gettype($schedulingDataExtensionsItem), var_export($schedulingDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\SchedulingData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\SchedulingData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get schedulingDate value
     * @return string|null
     */
    public function getSchedulingDate()
    {
        return $this->schedulingDate;
    }
    /**
     * Set schedulingDate value
     * @param string $schedulingDate
     * @return \StructType\SchedulingData
     */
    public function setSchedulingDate($schedulingDate = null)
    {
        // validation for constraint: string
        if (!is_null($schedulingDate) && !is_string($schedulingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulingDate, true), gettype($schedulingDate)), __LINE__);
        }
        $this->schedulingDate = $schedulingDate;
        return $this;
    }
    /**
     * Get schedulingEndDate value
     * @return string|null
     */
    public function getSchedulingEndDate()
    {
        return $this->schedulingEndDate;
    }
    /**
     * Set schedulingEndDate value
     * @param string $schedulingEndDate
     * @return \StructType\SchedulingData
     */
    public function setSchedulingEndDate($schedulingEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($schedulingEndDate) && !is_string($schedulingEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedulingEndDate, true), gettype($schedulingEndDate)), __LINE__);
        }
        $this->schedulingEndDate = $schedulingEndDate;
        return $this;
    }
    /**
     * Get teamMates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTeamMates()
    {
        return isset($this->teamMates) ? $this->teamMates : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTeamMates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTeamMates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTeamMatesForArrayConstraintsFromSetTeamMates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $schedulingDataTeamMatesItem) {
            // validation for constraint: itemType
            if (!is_string($schedulingDataTeamMatesItem)) {
                $invalidValues[] = is_object($schedulingDataTeamMatesItem) ? get_class($schedulingDataTeamMatesItem) : sprintf('%s(%s)', gettype($schedulingDataTeamMatesItem), var_export($schedulingDataTeamMatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The teamMates property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set teamMates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $teamMates
     * @return \StructType\SchedulingData
     */
    public function setTeamMates(array $teamMates = array())
    {
        // validation for constraint: array
        if ('' !== ($teamMatesArrayErrorMessage = self::validateTeamMatesForArrayConstraintsFromSetTeamMates($teamMates))) {
            throw new \InvalidArgumentException($teamMatesArrayErrorMessage, __LINE__);
        }
        if (is_null($teamMates) || (is_array($teamMates) && empty($teamMates))) {
            unset($this->teamMates);
        } else {
            $this->teamMates = $teamMates;
        }
        return $this;
    }
    /**
     * Add item to teamMates value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SchedulingData
     */
    public function addToTeamMates($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The teamMates property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->teamMates[] = $item;
        return $this;
    }
    /**
     * Get useSchedulingHour value
     * @return bool|null
     */
    public function getUseSchedulingHour()
    {
        return $this->useSchedulingHour;
    }
    /**
     * Set useSchedulingHour value
     * @param bool $useSchedulingHour
     * @return \StructType\SchedulingData
     */
    public function setUseSchedulingHour($useSchedulingHour = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSchedulingHour) && !is_bool($useSchedulingHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSchedulingHour, true), gettype($useSchedulingHour)), __LINE__);
        }
        $this->useSchedulingHour = $useSchedulingHour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SchedulingData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
