<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEvents StructType
 * Meta information extracted from the WSDL
 * - type: tns:getEvents
 * @subpackage Structs
 */
class GetEvents extends AbstractStructBase
{
    /**
     * The requestedEvents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $requestedEvents;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for getEvents
     * @uses GetEvents::setRequestedEvents()
     * @uses GetEvents::setOptions()
     * @param string[] $requestedEvents
     * @param \StructType\WsEntry[] $options
     */
    public function __construct(array $requestedEvents = array(), array $options = array())
    {
        $this
            ->setRequestedEvents($requestedEvents)
            ->setOptions($options);
    }
    /**
     * Get requestedEvents value
     * @return string[]|null
     */
    public function getRequestedEvents()
    {
        return $this->requestedEvents;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestedEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedEventsForArrayConstraintsFromSetRequestedEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEventsRequestedEventsItem) {
            // validation for constraint: itemType
            if (!is_string($getEventsRequestedEventsItem)) {
                $invalidValues[] = is_object($getEventsRequestedEventsItem) ? get_class($getEventsRequestedEventsItem) : sprintf('%s(%s)', gettype($getEventsRequestedEventsItem), var_export($getEventsRequestedEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The requestedEvents property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set requestedEvents value
     * @throws \InvalidArgumentException
     * @param string[] $requestedEvents
     * @return \StructType\GetEvents
     */
    public function setRequestedEvents(array $requestedEvents = array())
    {
        // validation for constraint: array
        if ('' !== ($requestedEventsArrayErrorMessage = self::validateRequestedEventsForArrayConstraintsFromSetRequestedEvents($requestedEvents))) {
            throw new \InvalidArgumentException($requestedEventsArrayErrorMessage, __LINE__);
        }
        $this->requestedEvents = $requestedEvents;
        return $this;
    }
    /**
     * Add item to requestedEvents value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetEvents
     */
    public function addToRequestedEvents($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The requestedEvents property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->requestedEvents[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getEventsOptionsItem) {
            // validation for constraint: itemType
            if (!$getEventsOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($getEventsOptionsItem) ? get_class($getEventsOptionsItem) : sprintf('%s(%s)', gettype($getEventsOptionsItem), var_export($getEventsOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\GetEvents
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\GetEvents
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEvents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
