<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalReferentialData StructType
 * @subpackage Structs
 */
class ExternalReferentialData extends ReferentialData
{
    /**
     * The customerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerName;
    /**
     * The equipmentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $equipmentName;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $location;
    /**
     * Constructor method for externalReferentialData
     * @uses ExternalReferentialData::setCustomerName()
     * @uses ExternalReferentialData::setEquipmentName()
     * @uses ExternalReferentialData::setExtensions()
     * @uses ExternalReferentialData::setLocation()
     * @param string $customerName
     * @param string $equipmentName
     * @param \StructType\WsValuedEntry[] $extensions
     * @param \StructType\Location $location
     */
    public function __construct($customerName = null, $equipmentName = null, array $extensions = array(), \StructType\Location $location = null)
    {
        $this
            ->setCustomerName($customerName)
            ->setEquipmentName($equipmentName)
            ->setExtensions($extensions)
            ->setLocation($location);
    }
    /**
     * Get customerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->customerName;
    }
    /**
     * Set customerName value
     * @param string $customerName
     * @return \StructType\ExternalReferentialData
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->customerName = $customerName;
        return $this;
    }
    /**
     * Get equipmentName value
     * @return string|null
     */
    public function getEquipmentName()
    {
        return $this->equipmentName;
    }
    /**
     * Set equipmentName value
     * @param string $equipmentName
     * @return \StructType\ExternalReferentialData
     */
    public function setEquipmentName($equipmentName = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentName) && !is_string($equipmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentName, true), gettype($equipmentName)), __LINE__);
        }
        $this->equipmentName = $equipmentName;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $externalReferentialDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$externalReferentialDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($externalReferentialDataExtensionsItem) ? get_class($externalReferentialDataExtensionsItem) : sprintf('%s(%s)', gettype($externalReferentialDataExtensionsItem), var_export($externalReferentialDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\ExternalReferentialData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\ExternalReferentialData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\Location $location
     * @return \StructType\ExternalReferentialData
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalReferentialData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
