<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportFieldUrl StructType
 * @subpackage Structs
 */
class ExtendedReportFieldUrl extends ExtendedReportField
{
    /**
     * The clickableMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clickableMode;
    /**
     * The queryFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $queryFields;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The urlType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $urlType;
    /**
     * Constructor method for extendedReportFieldUrl
     * @uses ExtendedReportFieldUrl::setClickableMode()
     * @uses ExtendedReportFieldUrl::setQueryFields()
     * @uses ExtendedReportFieldUrl::setUrl()
     * @uses ExtendedReportFieldUrl::setUrlType()
     * @param string $clickableMode
     * @param string[] $queryFields
     * @param string $url
     * @param string $urlType
     */
    public function __construct($clickableMode = null, array $queryFields = array(), $url = null, $urlType = null)
    {
        $this
            ->setClickableMode($clickableMode)
            ->setQueryFields($queryFields)
            ->setUrl($url)
            ->setUrlType($urlType);
    }
    /**
     * Get clickableMode value
     * @return string|null
     */
    public function getClickableMode()
    {
        return $this->clickableMode;
    }
    /**
     * Set clickableMode value
     * @uses \EnumType\ClickableOn::valueIsValid()
     * @uses \EnumType\ClickableOn::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clickableMode
     * @return \StructType\ExtendedReportFieldUrl
     */
    public function setClickableMode($clickableMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClickableOn::valueIsValid($clickableMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClickableOn', is_array($clickableMode) ? implode(', ', $clickableMode) : var_export($clickableMode, true), implode(', ', \EnumType\ClickableOn::getValidValues())), __LINE__);
        }
        $this->clickableMode = $clickableMode;
        return $this;
    }
    /**
     * Get queryFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getQueryFields()
    {
        return isset($this->queryFields) ? $this->queryFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQueryFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueryFieldsForArrayConstraintsFromSetQueryFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedReportFieldUrlQueryFieldsItem) {
            // validation for constraint: itemType
            if (!is_string($extendedReportFieldUrlQueryFieldsItem)) {
                $invalidValues[] = is_object($extendedReportFieldUrlQueryFieldsItem) ? get_class($extendedReportFieldUrlQueryFieldsItem) : sprintf('%s(%s)', gettype($extendedReportFieldUrlQueryFieldsItem), var_export($extendedReportFieldUrlQueryFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The queryFields property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set queryFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $queryFields
     * @return \StructType\ExtendedReportFieldUrl
     */
    public function setQueryFields(array $queryFields = array())
    {
        // validation for constraint: array
        if ('' !== ($queryFieldsArrayErrorMessage = self::validateQueryFieldsForArrayConstraintsFromSetQueryFields($queryFields))) {
            throw new \InvalidArgumentException($queryFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($queryFields) || (is_array($queryFields) && empty($queryFields))) {
            unset($this->queryFields);
        } else {
            $this->queryFields = $queryFields;
        }
        return $this;
    }
    /**
     * Add item to queryFields value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExtendedReportFieldUrl
     */
    public function addToQueryFields($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The queryFields property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->queryFields[] = $item;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\ExtendedReportFieldUrl
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get urlType value
     * @return string|null
     */
    public function getUrlType()
    {
        return $this->urlType;
    }
    /**
     * Set urlType value
     * @uses \EnumType\UrlType::valueIsValid()
     * @uses \EnumType\UrlType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlType
     * @return \StructType\ExtendedReportFieldUrl
     */
    public function setUrlType($urlType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrlType::valueIsValid($urlType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UrlType', is_array($urlType) ? implode(', ', $urlType) : var_export($urlType, true), implode(', ', \EnumType\UrlType::getValidValues())), __LINE__);
        }
        $this->urlType = $urlType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportFieldUrl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
