<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportField StructType
 * @subpackage Structs
 */
class ExtendedReportField extends ExtendedReportElement
{
    /**
     * The anomaly
     * @var bool
     */
    public $anomaly;
    /**
     * The compulsory
     * @var bool
     */
    public $compulsory;
    /**
     * The defaultValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultValue;
    /**
     * The instruction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $instruction;
    /**
     * The tableSummary
     * @var bool
     */
    public $tableSummary;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for extendedReportField
     * @uses ExtendedReportField::setAnomaly()
     * @uses ExtendedReportField::setCompulsory()
     * @uses ExtendedReportField::setDefaultValue()
     * @uses ExtendedReportField::setInstruction()
     * @uses ExtendedReportField::setTableSummary()
     * @uses ExtendedReportField::setType()
     * @uses ExtendedReportField::setValue()
     * @param bool $anomaly
     * @param bool $compulsory
     * @param string $defaultValue
     * @param string $instruction
     * @param bool $tableSummary
     * @param string $type
     * @param string $value
     */
    public function __construct($anomaly = null, $compulsory = null, $defaultValue = null, $instruction = null, $tableSummary = null, $type = null, $value = null)
    {
        $this
            ->setAnomaly($anomaly)
            ->setCompulsory($compulsory)
            ->setDefaultValue($defaultValue)
            ->setInstruction($instruction)
            ->setTableSummary($tableSummary)
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get anomaly value
     * @return bool|null
     */
    public function getAnomaly()
    {
        return $this->anomaly;
    }
    /**
     * Set anomaly value
     * @param bool $anomaly
     * @return \StructType\ExtendedReportField
     */
    public function setAnomaly($anomaly = null)
    {
        // validation for constraint: boolean
        if (!is_null($anomaly) && !is_bool($anomaly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anomaly, true), gettype($anomaly)), __LINE__);
        }
        $this->anomaly = $anomaly;
        return $this;
    }
    /**
     * Get compulsory value
     * @return bool|null
     */
    public function getCompulsory()
    {
        return $this->compulsory;
    }
    /**
     * Set compulsory value
     * @param bool $compulsory
     * @return \StructType\ExtendedReportField
     */
    public function setCompulsory($compulsory = null)
    {
        // validation for constraint: boolean
        if (!is_null($compulsory) && !is_bool($compulsory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compulsory, true), gettype($compulsory)), __LINE__);
        }
        $this->compulsory = $compulsory;
        return $this;
    }
    /**
     * Get defaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }
    /**
     * Set defaultValue value
     * @param string $defaultValue
     * @return \StructType\ExtendedReportField
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->defaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get instruction value
     * @return string|null
     */
    public function getInstruction()
    {
        return $this->instruction;
    }
    /**
     * Set instruction value
     * @uses \EnumType\Instruction::valueIsValid()
     * @uses \EnumType\Instruction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $instruction
     * @return \StructType\ExtendedReportField
     */
    public function setInstruction($instruction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Instruction::valueIsValid($instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Instruction', is_array($instruction) ? implode(', ', $instruction) : var_export($instruction, true), implode(', ', \EnumType\Instruction::getValidValues())), __LINE__);
        }
        $this->instruction = $instruction;
        return $this;
    }
    /**
     * Get tableSummary value
     * @return bool|null
     */
    public function getTableSummary()
    {
        return $this->tableSummary;
    }
    /**
     * Set tableSummary value
     * @param bool $tableSummary
     * @return \StructType\ExtendedReportField
     */
    public function setTableSummary($tableSummary = null)
    {
        // validation for constraint: boolean
        if (!is_null($tableSummary) && !is_bool($tableSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tableSummary, true), gettype($tableSummary)), __LINE__);
        }
        $this->tableSummary = $tableSummary;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ExtendedReportFieldType::valueIsValid()
     * @uses \EnumType\ExtendedReportFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ExtendedReportField
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExtendedReportFieldType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExtendedReportFieldType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ExtendedReportFieldType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\ExtendedReportField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
