<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedAttachment StructType
 * @subpackage Structs
 */
class ExtendedAttachment extends Attachment
{
    /**
     * The addedOnDevice
     * @var bool
     */
    public $addedOnDevice;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creationDate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The external
     * @var bool
     */
    public $external;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The lastModificationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModificationDate;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $size;
    /**
     * The unmodifiable
     * @var bool
     */
    public $unmodifiable;
    /**
     * Constructor method for extendedAttachment
     * @uses ExtendedAttachment::setAddedOnDevice()
     * @uses ExtendedAttachment::setCreationDate()
     * @uses ExtendedAttachment::setDescription()
     * @uses ExtendedAttachment::setExternal()
     * @uses ExtendedAttachment::setId()
     * @uses ExtendedAttachment::setLastModificationDate()
     * @uses ExtendedAttachment::setSize()
     * @uses ExtendedAttachment::setUnmodifiable()
     * @param bool $addedOnDevice
     * @param string $creationDate
     * @param string $description
     * @param bool $external
     * @param string $id
     * @param string $lastModificationDate
     * @param int $size
     * @param bool $unmodifiable
     */
    public function __construct($addedOnDevice = null, $creationDate = null, $description = null, $external = null, $id = null, $lastModificationDate = null, $size = null, $unmodifiable = null)
    {
        $this
            ->setAddedOnDevice($addedOnDevice)
            ->setCreationDate($creationDate)
            ->setDescription($description)
            ->setExternal($external)
            ->setId($id)
            ->setLastModificationDate($lastModificationDate)
            ->setSize($size)
            ->setUnmodifiable($unmodifiable);
    }
    /**
     * Get addedOnDevice value
     * @return bool|null
     */
    public function getAddedOnDevice()
    {
        return $this->addedOnDevice;
    }
    /**
     * Set addedOnDevice value
     * @param bool $addedOnDevice
     * @return \StructType\ExtendedAttachment
     */
    public function setAddedOnDevice($addedOnDevice = null)
    {
        // validation for constraint: boolean
        if (!is_null($addedOnDevice) && !is_bool($addedOnDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addedOnDevice, true), gettype($addedOnDevice)), __LINE__);
        }
        $this->addedOnDevice = $addedOnDevice;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\ExtendedAttachment
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExtendedAttachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get external value
     * @return bool|null
     */
    public function getExternal()
    {
        return $this->external;
    }
    /**
     * Set external value
     * @param bool $external
     * @return \StructType\ExtendedAttachment
     */
    public function setExternal($external = null)
    {
        // validation for constraint: boolean
        if (!is_null($external) && !is_bool($external)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($external, true), gettype($external)), __LINE__);
        }
        $this->external = $external;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ExtendedAttachment
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lastModificationDate value
     * @return string|null
     */
    public function getLastModificationDate()
    {
        return $this->lastModificationDate;
    }
    /**
     * Set lastModificationDate value
     * @param string $lastModificationDate
     * @return \StructType\ExtendedAttachment
     */
    public function setLastModificationDate($lastModificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModificationDate) && !is_string($lastModificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModificationDate, true), gettype($lastModificationDate)), __LINE__);
        }
        $this->lastModificationDate = $lastModificationDate;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\ExtendedAttachment
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get unmodifiable value
     * @return bool|null
     */
    public function getUnmodifiable()
    {
        return $this->unmodifiable;
    }
    /**
     * Set unmodifiable value
     * @param bool $unmodifiable
     * @return \StructType\ExtendedAttachment
     */
    public function setUnmodifiable($unmodifiable = null)
    {
        // validation for constraint: boolean
        if (!is_null($unmodifiable) && !is_bool($unmodifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unmodifiable, true), gettype($unmodifiable)), __LINE__);
        }
        $this->unmodifiable = $unmodifiable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
