<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteEvents StructType
 * Meta information extracted from the WSDL
 * - type: tns:deleteEvents
 * @subpackage Structs
 */
class DeleteEvents extends AbstractStructBase
{
    /**
     * The eventsToDelete
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $eventsToDelete;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for deleteEvents
     * @uses DeleteEvents::setEventsToDelete()
     * @uses DeleteEvents::setOptions()
     * @param string[] $eventsToDelete
     * @param \StructType\WsEntry[] $options
     */
    public function __construct(array $eventsToDelete = array(), array $options = array())
    {
        $this
            ->setEventsToDelete($eventsToDelete)
            ->setOptions($options);
    }
    /**
     * Get eventsToDelete value
     * @return string[]|null
     */
    public function getEventsToDelete()
    {
        return $this->eventsToDelete;
    }
    /**
     * This method is responsible for validating the values passed to the setEventsToDelete method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventsToDelete method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsToDeleteForArrayConstraintsFromSetEventsToDelete(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteEventsEventsToDeleteItem) {
            // validation for constraint: itemType
            if (!is_string($deleteEventsEventsToDeleteItem)) {
                $invalidValues[] = is_object($deleteEventsEventsToDeleteItem) ? get_class($deleteEventsEventsToDeleteItem) : sprintf('%s(%s)', gettype($deleteEventsEventsToDeleteItem), var_export($deleteEventsEventsToDeleteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eventsToDelete property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eventsToDelete value
     * @throws \InvalidArgumentException
     * @param string[] $eventsToDelete
     * @return \StructType\DeleteEvents
     */
    public function setEventsToDelete(array $eventsToDelete = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsToDeleteArrayErrorMessage = self::validateEventsToDeleteForArrayConstraintsFromSetEventsToDelete($eventsToDelete))) {
            throw new \InvalidArgumentException($eventsToDeleteArrayErrorMessage, __LINE__);
        }
        $this->eventsToDelete = $eventsToDelete;
        return $this;
    }
    /**
     * Add item to eventsToDelete value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeleteEvents
     */
    public function addToEventsToDelete($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The eventsToDelete property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eventsToDelete[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteEventsOptionsItem) {
            // validation for constraint: itemType
            if (!$deleteEventsOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($deleteEventsOptionsItem) ? get_class($deleteEventsOptionsItem) : sprintf('%s(%s)', gettype($deleteEventsOptionsItem), var_export($deleteEventsOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\DeleteEvents
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\DeleteEvents
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteEvents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
