<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dateConstraint StructType
 * @subpackage Structs
 */
class DateConstraint extends AbstractStructBase
{
    /**
     * The dateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $dateRange;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for dateConstraint
     * @uses DateConstraint::setDateRange()
     * @uses DateConstraint::setName()
     * @param string[] $dateRange
     * @param string $name
     */
    public function __construct(array $dateRange = array(), $name = null)
    {
        $this
            ->setDateRange($dateRange)
            ->setName($name);
    }
    /**
     * Get dateRange value
     * @return string[]|null
     */
    public function getDateRange()
    {
        return $this->dateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setDateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateRangeForArrayConstraintsFromSetDateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dateConstraintDateRangeItem) {
            // validation for constraint: itemType
            if (!is_string($dateConstraintDateRangeItem)) {
                $invalidValues[] = is_object($dateConstraintDateRangeItem) ? get_class($dateConstraintDateRangeItem) : sprintf('%s(%s)', gettype($dateConstraintDateRangeItem), var_export($dateConstraintDateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateRange property can only contain items of type dateTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateRange value
     * @throws \InvalidArgumentException
     * @param string[] $dateRange
     * @return \StructType\DateConstraint
     */
    public function setDateRange(array $dateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($dateRangeArrayErrorMessage = self::validateDateRangeForArrayConstraintsFromSetDateRange($dateRange))) {
            throw new \InvalidArgumentException($dateRangeArrayErrorMessage, __LINE__);
        }
        $this->dateRange = $dateRange;
        return $this;
    }
    /**
     * Add item to dateRange value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DateConstraint
     */
    public function addToDateRange($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The dateRange property can only contain items of type dateTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateRange[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DateConstraint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateConstraint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
