<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for completionData StructType
 * @subpackage Structs
 */
class CompletionData extends AbstractStructBase
{
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The fields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReportElement[]
     */
    public $fields;
    /**
     * The lifecycleTransitionDates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LifecycleTransitionDate[]
     */
    public $lifecycleTransitionDates;
    /**
     * The usedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UsedItem[]
     */
    public $usedItems;
    /**
     * Constructor method for completionData
     * @uses CompletionData::setExtensions()
     * @uses CompletionData::setFields()
     * @uses CompletionData::setLifecycleTransitionDates()
     * @uses CompletionData::setUsedItems()
     * @param \StructType\WsValuedEntry[] $extensions
     * @param \StructType\ReportElement[] $fields
     * @param \StructType\LifecycleTransitionDate[] $lifecycleTransitionDates
     * @param \StructType\UsedItem[] $usedItems
     */
    public function __construct(array $extensions = array(), array $fields = array(), array $lifecycleTransitionDates = array(), array $usedItems = array())
    {
        $this
            ->setExtensions($extensions)
            ->setFields($fields)
            ->setLifecycleTransitionDates($lifecycleTransitionDates)
            ->setUsedItems($usedItems);
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completionDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$completionDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($completionDataExtensionsItem) ? get_class($completionDataExtensionsItem) : sprintf('%s(%s)', gettype($completionDataExtensionsItem), var_export($completionDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\CompletionData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\CompletionData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get fields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReportElement[]|null
     */
    public function getFields()
    {
        return isset($this->fields) ? $this->fields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldsForArrayConstraintsFromSetFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completionDataFieldsItem) {
            // validation for constraint: itemType
            if (!$completionDataFieldsItem instanceof \StructType\ReportElement) {
                $invalidValues[] = is_object($completionDataFieldsItem) ? get_class($completionDataFieldsItem) : sprintf('%s(%s)', gettype($completionDataFieldsItem), var_export($completionDataFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fields property can only contain items of type \StructType\ReportElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReportElement[] $fields
     * @return \StructType\CompletionData
     */
    public function setFields(array $fields = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldsArrayErrorMessage = self::validateFieldsForArrayConstraintsFromSetFields($fields))) {
            throw new \InvalidArgumentException($fieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($fields) || (is_array($fields) && empty($fields))) {
            unset($this->fields);
        } else {
            $this->fields = $fields;
        }
        return $this;
    }
    /**
     * Add item to fields value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportElement $item
     * @return \StructType\CompletionData
     */
    public function addToFields(\StructType\ReportElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReportElement) {
            throw new \InvalidArgumentException(sprintf('The fields property can only contain items of type \StructType\ReportElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fields[] = $item;
        return $this;
    }
    /**
     * Get lifecycleTransitionDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LifecycleTransitionDate[]|null
     */
    public function getLifecycleTransitionDates()
    {
        return isset($this->lifecycleTransitionDates) ? $this->lifecycleTransitionDates : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLifecycleTransitionDates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLifecycleTransitionDates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLifecycleTransitionDatesForArrayConstraintsFromSetLifecycleTransitionDates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completionDataLifecycleTransitionDatesItem) {
            // validation for constraint: itemType
            if (!$completionDataLifecycleTransitionDatesItem instanceof \StructType\LifecycleTransitionDate) {
                $invalidValues[] = is_object($completionDataLifecycleTransitionDatesItem) ? get_class($completionDataLifecycleTransitionDatesItem) : sprintf('%s(%s)', gettype($completionDataLifecycleTransitionDatesItem), var_export($completionDataLifecycleTransitionDatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lifecycleTransitionDates property can only contain items of type \StructType\LifecycleTransitionDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lifecycleTransitionDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LifecycleTransitionDate[] $lifecycleTransitionDates
     * @return \StructType\CompletionData
     */
    public function setLifecycleTransitionDates(array $lifecycleTransitionDates = array())
    {
        // validation for constraint: array
        if ('' !== ($lifecycleTransitionDatesArrayErrorMessage = self::validateLifecycleTransitionDatesForArrayConstraintsFromSetLifecycleTransitionDates($lifecycleTransitionDates))) {
            throw new \InvalidArgumentException($lifecycleTransitionDatesArrayErrorMessage, __LINE__);
        }
        if (is_null($lifecycleTransitionDates) || (is_array($lifecycleTransitionDates) && empty($lifecycleTransitionDates))) {
            unset($this->lifecycleTransitionDates);
        } else {
            $this->lifecycleTransitionDates = $lifecycleTransitionDates;
        }
        return $this;
    }
    /**
     * Add item to lifecycleTransitionDates value
     * @throws \InvalidArgumentException
     * @param \StructType\LifecycleTransitionDate $item
     * @return \StructType\CompletionData
     */
    public function addToLifecycleTransitionDates(\StructType\LifecycleTransitionDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LifecycleTransitionDate) {
            throw new \InvalidArgumentException(sprintf('The lifecycleTransitionDates property can only contain items of type \StructType\LifecycleTransitionDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lifecycleTransitionDates[] = $item;
        return $this;
    }
    /**
     * Get usedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UsedItem[]|null
     */
    public function getUsedItems()
    {
        return isset($this->usedItems) ? $this->usedItems : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUsedItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsedItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsedItemsForArrayConstraintsFromSetUsedItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $completionDataUsedItemsItem) {
            // validation for constraint: itemType
            if (!$completionDataUsedItemsItem instanceof \StructType\UsedItem) {
                $invalidValues[] = is_object($completionDataUsedItemsItem) ? get_class($completionDataUsedItemsItem) : sprintf('%s(%s)', gettype($completionDataUsedItemsItem), var_export($completionDataUsedItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The usedItems property can only contain items of type \StructType\UsedItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set usedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UsedItem[] $usedItems
     * @return \StructType\CompletionData
     */
    public function setUsedItems(array $usedItems = array())
    {
        // validation for constraint: array
        if ('' !== ($usedItemsArrayErrorMessage = self::validateUsedItemsForArrayConstraintsFromSetUsedItems($usedItems))) {
            throw new \InvalidArgumentException($usedItemsArrayErrorMessage, __LINE__);
        }
        if (is_null($usedItems) || (is_array($usedItems) && empty($usedItems))) {
            unset($this->usedItems);
        } else {
            $this->usedItems = $usedItems;
        }
        return $this;
    }
    /**
     * Add item to usedItems value
     * @throws \InvalidArgumentException
     * @param \StructType\UsedItem $item
     * @return \StructType\CompletionData
     */
    public function addToUsedItems(\StructType\UsedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UsedItem) {
            throw new \InvalidArgumentException(sprintf('The usedItems property can only contain items of type \StructType\UsedItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->usedItems[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompletionData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
