<?php

namespace EnumType;

/**
 * This class stands for insertionPosition EnumType
 * @subpackage Enumerations
 */
class InsertionPosition
{
    /**
     * Constant for value 'INDEX'
     * @return string 'INDEX'
     */
    const VALUE_INDEX = 'INDEX';
    /**
     * Constant for value 'FIXED_INDEX'
     * @return string 'FIXED_INDEX'
     */
    const VALUE_FIXED_INDEX = 'FIXED_INDEX';
    /**
     * Constant for value 'BEFORE'
     * @return string 'BEFORE'
     */
    const VALUE_BEFORE = 'BEFORE';
    /**
     * Constant for value 'AFTER'
     * @return string 'AFTER'
     */
    const VALUE_AFTER = 'AFTER';
    /**
     * Constant for value 'FIRST'
     * @return string 'FIRST'
     */
    const VALUE_FIRST = 'FIRST';
    /**
     * Constant for value 'LAST'
     * @return string 'LAST'
     */
    const VALUE_LAST = 'LAST';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INDEX
     * @uses self::VALUE_FIXED_INDEX
     * @uses self::VALUE_BEFORE
     * @uses self::VALUE_AFTER
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_LAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INDEX,
            self::VALUE_FIXED_INDEX,
            self::VALUE_BEFORE,
            self::VALUE_AFTER,
            self::VALUE_FIRST,
            self::VALUE_LAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
