<?php

namespace EnumType;

/**
 * This class stands for editable EnumType
 * @subpackage Enumerations
 */
class Editable
{
    /**
     * Constant for value 'ALWAYS'
     * @return string 'ALWAYS'
     */
    const VALUE_ALWAYS = 'ALWAYS';
    /**
     * Constant for value 'ONCE'
     * @return string 'ONCE'
     */
    const VALUE_ONCE = 'ONCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS
     * @uses self::VALUE_ONCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS,
            self::VALUE_ONCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
