<?php

namespace EnumType;

/**
 * This class stands for billingSectionPosition EnumType
 * @subpackage Enumerations
 */
class BillingSectionPosition
{
    /**
     * Constant for value 'TOP'
     * @return string 'TOP'
     */
    const VALUE_TOP = 'TOP';
    /**
     * Constant for value 'BOTTOM'
     * @return string 'BOTTOM'
     */
    const VALUE_BOTTOM = 'BOTTOM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOP
     * @uses self::VALUE_BOTTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOP,
            self::VALUE_BOTTOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
