<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for usedItem StructType
 * @subpackage Structs
 */
class UsedItem extends AbstractStructBase
{
    /**
     * The agentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentId;
    /**
     * The booked
     * @var bool
     */
    public $booked;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The dimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var float[]
     */
    public $dimensions;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The ordered
     * @var bool
     */
    public $ordered;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The sectionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sectionId;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumber;
    /**
     * The storeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeId;
    /**
     * The vatRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vatRate;
    /**
     * Constructor method for usedItem
     * @uses UsedItem::setAgentId()
     * @uses UsedItem::setBooked()
     * @uses UsedItem::setComment()
     * @uses UsedItem::setDimensions()
     * @uses UsedItem::setExtensions()
     * @uses UsedItem::setId()
     * @uses UsedItem::setOrdered()
     * @uses UsedItem::setQuantity()
     * @uses UsedItem::setSectionId()
     * @uses UsedItem::setSerialNumber()
     * @uses UsedItem::setStoreId()
     * @uses UsedItem::setVatRate()
     * @param string $agentId
     * @param bool $booked
     * @param string $comment
     * @param float[] $dimensions
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $id
     * @param bool $ordered
     * @param float $quantity
     * @param string $sectionId
     * @param string $serialNumber
     * @param string $storeId
     * @param float $vatRate
     */
    public function __construct($agentId = null, $booked = null, $comment = null, array $dimensions = array(), array $extensions = array(), $id = null, $ordered = null, $quantity = null, $sectionId = null, $serialNumber = null, $storeId = null, $vatRate = null)
    {
        $this
            ->setAgentId($agentId)
            ->setBooked($booked)
            ->setComment($comment)
            ->setDimensions($dimensions)
            ->setExtensions($extensions)
            ->setId($id)
            ->setOrdered($ordered)
            ->setQuantity($quantity)
            ->setSectionId($sectionId)
            ->setSerialNumber($serialNumber)
            ->setStoreId($storeId)
            ->setVatRate($vatRate);
    }
    /**
     * Get agentId value
     * @return string|null
     */
    public function getAgentId()
    {
        return $this->agentId;
    }
    /**
     * Set agentId value
     * @param string $agentId
     * @return \StructType\UsedItem
     */
    public function setAgentId($agentId = null)
    {
        // validation for constraint: string
        if (!is_null($agentId) && !is_string($agentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentId, true), gettype($agentId)), __LINE__);
        }
        $this->agentId = $agentId;
        return $this;
    }
    /**
     * Get booked value
     * @return bool|null
     */
    public function getBooked()
    {
        return $this->booked;
    }
    /**
     * Set booked value
     * @param bool $booked
     * @return \StructType\UsedItem
     */
    public function setBooked($booked = null)
    {
        // validation for constraint: boolean
        if (!is_null($booked) && !is_bool($booked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booked, true), gettype($booked)), __LINE__);
        }
        $this->booked = $booked;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\UsedItem
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get dimensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float[]|null
     */
    public function getDimensions()
    {
        return isset($this->dimensions) ? $this->dimensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDimensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDimensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDimensionsForArrayConstraintsFromSetDimensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $usedItemDimensionsItem) {
            // validation for constraint: itemType
            if (!(is_float($usedItemDimensionsItem) || is_numeric($usedItemDimensionsItem))) {
                $invalidValues[] = is_object($usedItemDimensionsItem) ? get_class($usedItemDimensionsItem) : sprintf('%s(%s)', gettype($usedItemDimensionsItem), var_export($usedItemDimensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dimensions property can only contain items of type double, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dimensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param float[] $dimensions
     * @return \StructType\UsedItem
     */
    public function setDimensions(array $dimensions = array())
    {
        // validation for constraint: array
        if ('' !== ($dimensionsArrayErrorMessage = self::validateDimensionsForArrayConstraintsFromSetDimensions($dimensions))) {
            throw new \InvalidArgumentException($dimensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($dimensions) || (is_array($dimensions) && empty($dimensions))) {
            unset($this->dimensions);
        } else {
            $this->dimensions = $dimensions;
        }
        return $this;
    }
    /**
     * Add item to dimensions value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \StructType\UsedItem
     */
    public function addToDimensions($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The dimensions property can only contain items of type double, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dimensions[] = $item;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $usedItemExtensionsItem) {
            // validation for constraint: itemType
            if (!$usedItemExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($usedItemExtensionsItem) ? get_class($usedItemExtensionsItem) : sprintf('%s(%s)', gettype($usedItemExtensionsItem), var_export($usedItemExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\UsedItem
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\UsedItem
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\UsedItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get ordered value
     * @return bool|null
     */
    public function getOrdered()
    {
        return $this->ordered;
    }
    /**
     * Set ordered value
     * @param bool $ordered
     * @return \StructType\UsedItem
     */
    public function setOrdered($ordered = null)
    {
        // validation for constraint: boolean
        if (!is_null($ordered) && !is_bool($ordered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ordered, true), gettype($ordered)), __LINE__);
        }
        $this->ordered = $ordered;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\UsedItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sectionId value
     * @return string|null
     */
    public function getSectionId()
    {
        return $this->sectionId;
    }
    /**
     * Set sectionId value
     * @param string $sectionId
     * @return \StructType\UsedItem
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        $this->sectionId = $sectionId;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\UsedItem
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get storeId value
     * @return string|null
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param string $storeId
     * @return \StructType\UsedItem
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: string
        if (!is_null($storeId) && !is_string($storeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get vatRate value
     * @return float|null
     */
    public function getVatRate()
    {
        return $this->vatRate;
    }
    /**
     * Set vatRate value
     * @param float $vatRate
     * @return \StructType\UsedItem
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: float
        if (!is_null($vatRate) && !(is_float($vatRate) || is_numeric($vatRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatRate, true), gettype($vatRate)), __LINE__);
        }
        $this->vatRate = $vatRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UsedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
