<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for skill StructType
 * @subpackage Structs
 */
class Skill extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $level;
    /**
     * Constructor method for skill
     * @uses Skill::setId()
     * @uses Skill::setLevel()
     * @param string $id
     * @param string $level
     */
    public function __construct($id = null, $level = null)
    {
        $this
            ->setId($id)
            ->setLevel($level);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Skill
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @uses \EnumType\Level::valueIsValid()
     * @uses \EnumType\Level::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \StructType\Skill
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Level::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Level', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \EnumType\Level::getValidValues())), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Skill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
