<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceOrderInsertion StructType
 * @subpackage Structs
 */
class ServiceOrderInsertion extends ServiceOrderPosition
{
    /**
     * The position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $position;
    /**
     * The relativeBusinessEventId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relativeBusinessEventId;
    /**
     * Constructor method for serviceOrderInsertion
     * @uses ServiceOrderInsertion::setPosition()
     * @uses ServiceOrderInsertion::setRelativeBusinessEventId()
     * @param string $position
     * @param string $relativeBusinessEventId
     */
    public function __construct($position = null, $relativeBusinessEventId = null)
    {
        $this
            ->setPosition($position)
            ->setRelativeBusinessEventId($relativeBusinessEventId);
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @uses \EnumType\InsertionPosition::valueIsValid()
     * @uses \EnumType\InsertionPosition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position
     * @return \StructType\ServiceOrderInsertion
     */
    public function setPosition($position = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsertionPosition::valueIsValid($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsertionPosition', is_array($position) ? implode(', ', $position) : var_export($position, true), implode(', ', \EnumType\InsertionPosition::getValidValues())), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get relativeBusinessEventId value
     * @return string|null
     */
    public function getRelativeBusinessEventId()
    {
        return $this->relativeBusinessEventId;
    }
    /**
     * Set relativeBusinessEventId value
     * @param string $relativeBusinessEventId
     * @return \StructType\ServiceOrderInsertion
     */
    public function setRelativeBusinessEventId($relativeBusinessEventId = null)
    {
        // validation for constraint: string
        if (!is_null($relativeBusinessEventId) && !is_string($relativeBusinessEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativeBusinessEventId, true), gettype($relativeBusinessEventId)), __LINE__);
        }
        $this->relativeBusinessEventId = $relativeBusinessEventId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceOrderInsertion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
