<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportElement StructType
 * @subpackage Structs
 */
abstract class ExtendedReportElement extends ReportElement
{
    /**
     * The condition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $condition;
    /**
     * The insertBeforePoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $insertBeforePoint;
    /**
     * The insertionPointId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insertionPointId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for extendedReportElement
     * @uses ExtendedReportElement::setCondition()
     * @uses ExtendedReportElement::setInsertBeforePoint()
     * @uses ExtendedReportElement::setInsertionPointId()
     * @uses ExtendedReportElement::setName()
     * @param string $condition
     * @param bool $insertBeforePoint
     * @param string $insertionPointId
     * @param string $name
     */
    public function __construct($condition = null, $insertBeforePoint = null, $insertionPointId = null, $name = null)
    {
        $this
            ->setCondition($condition)
            ->setInsertBeforePoint($insertBeforePoint)
            ->setInsertionPointId($insertionPointId)
            ->setName($name);
    }
    /**
     * Get condition value
     * @return string|null
     */
    public function getCondition()
    {
        return $this->condition;
    }
    /**
     * Set condition value
     * @param string $condition
     * @return \StructType\ExtendedReportElement
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: string
        if (!is_null($condition) && !is_string($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condition, true), gettype($condition)), __LINE__);
        }
        $this->condition = $condition;
        return $this;
    }
    /**
     * Get insertBeforePoint value
     * @return bool|null
     */
    public function getInsertBeforePoint()
    {
        return $this->insertBeforePoint;
    }
    /**
     * Set insertBeforePoint value
     * @param bool $insertBeforePoint
     * @return \StructType\ExtendedReportElement
     */
    public function setInsertBeforePoint($insertBeforePoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($insertBeforePoint) && !is_bool($insertBeforePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insertBeforePoint, true), gettype($insertBeforePoint)), __LINE__);
        }
        $this->insertBeforePoint = $insertBeforePoint;
        return $this;
    }
    /**
     * Get insertionPointId value
     * @return string|null
     */
    public function getInsertionPointId()
    {
        return $this->insertionPointId;
    }
    /**
     * Set insertionPointId value
     * @param string $insertionPointId
     * @return \StructType\ExtendedReportElement
     */
    public function setInsertionPointId($insertionPointId = null)
    {
        // validation for constraint: string
        if (!is_null($insertionPointId) && !is_string($insertionPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertionPointId, true), gettype($insertionPointId)), __LINE__);
        }
        $this->insertionPointId = $insertionPointId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ExtendedReportElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
