<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedItem StructType
 * @subpackage Structs
 */
class ExtendedItem extends UsedItem
{
    /**
     * The expectedDimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var float[]
     */
    public $expectedDimensions;
    /**
     * The expectedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $expectedQuantity;
    /**
     * The fixedPrice
     * @var bool
     */
    public $fixedPrice;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for extendedItem
     * @uses ExtendedItem::setExpectedDimensions()
     * @uses ExtendedItem::setExpectedQuantity()
     * @uses ExtendedItem::setFixedPrice()
     * @uses ExtendedItem::setName()
     * @uses ExtendedItem::setPrice()
     * @uses ExtendedItem::setReference()
     * @param float[] $expectedDimensions
     * @param float $expectedQuantity
     * @param bool $fixedPrice
     * @param string $name
     * @param float $price
     * @param string $reference
     */
    public function __construct(array $expectedDimensions = array(), $expectedQuantity = null, $fixedPrice = null, $name = null, $price = null, $reference = null)
    {
        $this
            ->setExpectedDimensions($expectedDimensions)
            ->setExpectedQuantity($expectedQuantity)
            ->setFixedPrice($fixedPrice)
            ->setName($name)
            ->setPrice($price)
            ->setReference($reference);
    }
    /**
     * Get expectedDimensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float[]|null
     */
    public function getExpectedDimensions()
    {
        return isset($this->expectedDimensions) ? $this->expectedDimensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedDimensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedDimensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedDimensionsForArrayConstraintsFromSetExpectedDimensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedItemExpectedDimensionsItem) {
            // validation for constraint: itemType
            if (!(is_float($extendedItemExpectedDimensionsItem) || is_numeric($extendedItemExpectedDimensionsItem))) {
                $invalidValues[] = is_object($extendedItemExpectedDimensionsItem) ? get_class($extendedItemExpectedDimensionsItem) : sprintf('%s(%s)', gettype($extendedItemExpectedDimensionsItem), var_export($extendedItemExpectedDimensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expectedDimensions property can only contain items of type double, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expectedDimensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param float[] $expectedDimensions
     * @return \StructType\ExtendedItem
     */
    public function setExpectedDimensions(array $expectedDimensions = array())
    {
        // validation for constraint: array
        if ('' !== ($expectedDimensionsArrayErrorMessage = self::validateExpectedDimensionsForArrayConstraintsFromSetExpectedDimensions($expectedDimensions))) {
            throw new \InvalidArgumentException($expectedDimensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($expectedDimensions) || (is_array($expectedDimensions) && empty($expectedDimensions))) {
            unset($this->expectedDimensions);
        } else {
            $this->expectedDimensions = $expectedDimensions;
        }
        return $this;
    }
    /**
     * Add item to expectedDimensions value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \StructType\ExtendedItem
     */
    public function addToExpectedDimensions($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The expectedDimensions property can only contain items of type double, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expectedDimensions[] = $item;
        return $this;
    }
    /**
     * Get expectedQuantity value
     * @return float|null
     */
    public function getExpectedQuantity()
    {
        return $this->expectedQuantity;
    }
    /**
     * Set expectedQuantity value
     * @param float $expectedQuantity
     * @return \StructType\ExtendedItem
     */
    public function setExpectedQuantity($expectedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($expectedQuantity) && !(is_float($expectedQuantity) || is_numeric($expectedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedQuantity, true), gettype($expectedQuantity)), __LINE__);
        }
        $this->expectedQuantity = $expectedQuantity;
        return $this;
    }
    /**
     * Get fixedPrice value
     * @return bool|null
     */
    public function getFixedPrice()
    {
        return $this->fixedPrice;
    }
    /**
     * Set fixedPrice value
     * @param bool $fixedPrice
     * @return \StructType\ExtendedItem
     */
    public function setFixedPrice($fixedPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedPrice) && !is_bool($fixedPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedPrice, true), gettype($fixedPrice)), __LINE__);
        }
        $this->fixedPrice = $fixedPrice;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ExtendedItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ExtendedItem
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ExtendedItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
