<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createEvents StructType
 * Meta information extracted from the WSDL
 * - type: tns:createEvents
 * @subpackage Structs
 */
class CreateEvents extends AbstractStructBase
{
    /**
     * The events
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessEvent[]
     */
    public $events;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for createEvents
     * @uses CreateEvents::setEvents()
     * @uses CreateEvents::setOptions()
     * @param \StructType\BusinessEvent[] $events
     * @param \StructType\WsEntry[] $options
     */
    public function __construct(array $events = array(), array $options = array())
    {
        $this
            ->setEvents($events)
            ->setOptions($options);
    }
    /**
     * Get events value
     * @return \StructType\BusinessEvent[]|null
     */
    public function getEvents()
    {
        return $this->events;
    }
    /**
     * This method is responsible for validating the values passed to the setEvents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventsForArrayConstraintsFromSetEvents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createEventsEventsItem) {
            // validation for constraint: itemType
            if (!$createEventsEventsItem instanceof \StructType\BusinessEvent) {
                $invalidValues[] = is_object($createEventsEventsItem) ? get_class($createEventsEventsItem) : sprintf('%s(%s)', gettype($createEventsEventsItem), var_export($createEventsEventsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The events property can only contain items of type \StructType\BusinessEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set events value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEvent[] $events
     * @return \StructType\CreateEvents
     */
    public function setEvents(array $events = array())
    {
        // validation for constraint: array
        if ('' !== ($eventsArrayErrorMessage = self::validateEventsForArrayConstraintsFromSetEvents($events))) {
            throw new \InvalidArgumentException($eventsArrayErrorMessage, __LINE__);
        }
        $this->events = $events;
        return $this;
    }
    /**
     * Add item to events value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEvent $item
     * @return \StructType\CreateEvents
     */
    public function addToEvents(\StructType\BusinessEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessEvent) {
            throw new \InvalidArgumentException(sprintf('The events property can only contain items of type \StructType\BusinessEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->events[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createEventsOptionsItem) {
            // validation for constraint: itemType
            if (!$createEventsOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($createEventsOptionsItem) ? get_class($createEventsOptionsItem) : sprintf('%s(%s)', gettype($createEventsOptionsItem), var_export($createEventsOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\CreateEvents
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\CreateEvents
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateEvents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
