<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEventsRequestResult StructType
 * @subpackage Structs
 */
class BusinessEventsRequestResult extends EntitiesRequestResult
{
    /**
     * The entities
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessEvent[]
     */
    public $entities;
    /**
     * Constructor method for businessEventsRequestResult
     * @uses BusinessEventsRequestResult::setEntities()
     * @param \StructType\BusinessEvent[] $entities
     */
    public function __construct(array $entities = array())
    {
        $this
            ->setEntities($entities);
    }
    /**
     * Get entities value
     * @return \StructType\BusinessEvent[]|null
     */
    public function getEntities()
    {
        return $this->entities;
    }
    /**
     * This method is responsible for validating the values passed to the setEntities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntitiesForArrayConstraintsFromSetEntities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventsRequestResultEntitiesItem) {
            // validation for constraint: itemType
            if (!$businessEventsRequestResultEntitiesItem instanceof \StructType\BusinessEvent) {
                $invalidValues[] = is_object($businessEventsRequestResultEntitiesItem) ? get_class($businessEventsRequestResultEntitiesItem) : sprintf('%s(%s)', gettype($businessEventsRequestResultEntitiesItem), var_export($businessEventsRequestResultEntitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The entities property can only contain items of type \StructType\BusinessEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set entities value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEvent[] $entities
     * @return \StructType\BusinessEventsRequestResult
     */
    public function setEntities(array $entities = array())
    {
        // validation for constraint: array
        if ('' !== ($entitiesArrayErrorMessage = self::validateEntitiesForArrayConstraintsFromSetEntities($entities))) {
            throw new \InvalidArgumentException($entitiesArrayErrorMessage, __LINE__);
        }
        $this->entities = $entities;
        return $this;
    }
    /**
     * Add item to entities value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessEvent $item
     * @return \StructType\BusinessEventsRequestResult
     */
    public function addToEntities(\StructType\BusinessEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessEvent) {
            throw new \InvalidArgumentException(sprintf('The entities property can only contain items of type \StructType\BusinessEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->entities[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEventsRequestResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
