<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEventsRequest StructType
 * @subpackage Structs
 */
class BusinessEventsRequest extends AbstractStructBase
{
    /**
     * The agentIdConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $agentIdConstraint;
    /**
     * The dateConstraints
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateConstraint[]
     */
    public $dateConstraints;
    /**
     * The serviceOrderConstraint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceOrderConstraint
     */
    public $serviceOrderConstraint;
    /**
     * The statusConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $statusConstraint;
    /**
     * The typeConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $typeConstraint;
    /**
     * Constructor method for businessEventsRequest
     * @uses BusinessEventsRequest::setAgentIdConstraint()
     * @uses BusinessEventsRequest::setDateConstraints()
     * @uses BusinessEventsRequest::setServiceOrderConstraint()
     * @uses BusinessEventsRequest::setStatusConstraint()
     * @uses BusinessEventsRequest::setTypeConstraint()
     * @param string[] $agentIdConstraint
     * @param \StructType\DateConstraint[] $dateConstraints
     * @param \StructType\ServiceOrderConstraint $serviceOrderConstraint
     * @param string[] $statusConstraint
     * @param string[] $typeConstraint
     */
    public function __construct(array $agentIdConstraint = array(), array $dateConstraints = array(), \StructType\ServiceOrderConstraint $serviceOrderConstraint = null, array $statusConstraint = array(), array $typeConstraint = array())
    {
        $this
            ->setAgentIdConstraint($agentIdConstraint)
            ->setDateConstraints($dateConstraints)
            ->setServiceOrderConstraint($serviceOrderConstraint)
            ->setStatusConstraint($statusConstraint)
            ->setTypeConstraint($typeConstraint);
    }
    /**
     * Get agentIdConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAgentIdConstraint()
    {
        return isset($this->agentIdConstraint) ? $this->agentIdConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAgentIdConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentIdConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentIdConstraintForArrayConstraintsFromSetAgentIdConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventsRequestAgentIdConstraintItem) {
            // validation for constraint: itemType
            if (!is_string($businessEventsRequestAgentIdConstraintItem)) {
                $invalidValues[] = is_object($businessEventsRequestAgentIdConstraintItem) ? get_class($businessEventsRequestAgentIdConstraintItem) : sprintf('%s(%s)', gettype($businessEventsRequestAgentIdConstraintItem), var_export($businessEventsRequestAgentIdConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The agentIdConstraint property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set agentIdConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $agentIdConstraint
     * @return \StructType\BusinessEventsRequest
     */
    public function setAgentIdConstraint(array $agentIdConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($agentIdConstraintArrayErrorMessage = self::validateAgentIdConstraintForArrayConstraintsFromSetAgentIdConstraint($agentIdConstraint))) {
            throw new \InvalidArgumentException($agentIdConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($agentIdConstraint) || (is_array($agentIdConstraint) && empty($agentIdConstraint))) {
            unset($this->agentIdConstraint);
        } else {
            $this->agentIdConstraint = $agentIdConstraint;
        }
        return $this;
    }
    /**
     * Add item to agentIdConstraint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BusinessEventsRequest
     */
    public function addToAgentIdConstraint($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The agentIdConstraint property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->agentIdConstraint[] = $item;
        return $this;
    }
    /**
     * Get dateConstraints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateConstraint[]|null
     */
    public function getDateConstraints()
    {
        return isset($this->dateConstraints) ? $this->dateConstraints : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDateConstraints method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateConstraints method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateConstraintsForArrayConstraintsFromSetDateConstraints(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventsRequestDateConstraintsItem) {
            // validation for constraint: itemType
            if (!$businessEventsRequestDateConstraintsItem instanceof \StructType\DateConstraint) {
                $invalidValues[] = is_object($businessEventsRequestDateConstraintsItem) ? get_class($businessEventsRequestDateConstraintsItem) : sprintf('%s(%s)', gettype($businessEventsRequestDateConstraintsItem), var_export($businessEventsRequestDateConstraintsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateConstraints property can only contain items of type \StructType\DateConstraint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateConstraints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DateConstraint[] $dateConstraints
     * @return \StructType\BusinessEventsRequest
     */
    public function setDateConstraints(array $dateConstraints = array())
    {
        // validation for constraint: array
        if ('' !== ($dateConstraintsArrayErrorMessage = self::validateDateConstraintsForArrayConstraintsFromSetDateConstraints($dateConstraints))) {
            throw new \InvalidArgumentException($dateConstraintsArrayErrorMessage, __LINE__);
        }
        if (is_null($dateConstraints) || (is_array($dateConstraints) && empty($dateConstraints))) {
            unset($this->dateConstraints);
        } else {
            $this->dateConstraints = $dateConstraints;
        }
        return $this;
    }
    /**
     * Add item to dateConstraints value
     * @throws \InvalidArgumentException
     * @param \StructType\DateConstraint $item
     * @return \StructType\BusinessEventsRequest
     */
    public function addToDateConstraints(\StructType\DateConstraint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DateConstraint) {
            throw new \InvalidArgumentException(sprintf('The dateConstraints property can only contain items of type \StructType\DateConstraint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateConstraints[] = $item;
        return $this;
    }
    /**
     * Get serviceOrderConstraint value
     * @return \StructType\ServiceOrderConstraint|null
     */
    public function getServiceOrderConstraint()
    {
        return $this->serviceOrderConstraint;
    }
    /**
     * Set serviceOrderConstraint value
     * @param \StructType\ServiceOrderConstraint $serviceOrderConstraint
     * @return \StructType\BusinessEventsRequest
     */
    public function setServiceOrderConstraint(\StructType\ServiceOrderConstraint $serviceOrderConstraint = null)
    {
        $this->serviceOrderConstraint = $serviceOrderConstraint;
        return $this;
    }
    /**
     * Get statusConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStatusConstraint()
    {
        return isset($this->statusConstraint) ? $this->statusConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusConstraintForArrayConstraintsFromSetStatusConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventsRequestStatusConstraintItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Status::valueIsValid($businessEventsRequestStatusConstraintItem)) {
                $invalidValues[] = is_object($businessEventsRequestStatusConstraintItem) ? get_class($businessEventsRequestStatusConstraintItem) : sprintf('%s(%s)', gettype($businessEventsRequestStatusConstraintItem), var_export($businessEventsRequestStatusConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Status', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Status::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statusConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusConstraint
     * @return \StructType\BusinessEventsRequest
     */
    public function setStatusConstraint(array $statusConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($statusConstraintArrayErrorMessage = self::validateStatusConstraintForArrayConstraintsFromSetStatusConstraint($statusConstraint))) {
            throw new \InvalidArgumentException($statusConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($statusConstraint) || (is_array($statusConstraint) && empty($statusConstraint))) {
            unset($this->statusConstraint);
        } else {
            $this->statusConstraint = $statusConstraint;
        }
        return $this;
    }
    /**
     * Add item to statusConstraint value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BusinessEventsRequest
     */
    public function addToStatusConstraint($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Status', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->statusConstraint[] = $item;
        return $this;
    }
    /**
     * Get typeConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTypeConstraint()
    {
        return isset($this->typeConstraint) ? $this->typeConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeConstraintForArrayConstraintsFromSetTypeConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventsRequestTypeConstraintItem) {
            // validation for constraint: itemType
            if (!is_string($businessEventsRequestTypeConstraintItem)) {
                $invalidValues[] = is_object($businessEventsRequestTypeConstraintItem) ? get_class($businessEventsRequestTypeConstraintItem) : sprintf('%s(%s)', gettype($businessEventsRequestTypeConstraintItem), var_export($businessEventsRequestTypeConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The typeConstraint property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set typeConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $typeConstraint
     * @return \StructType\BusinessEventsRequest
     */
    public function setTypeConstraint(array $typeConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($typeConstraintArrayErrorMessage = self::validateTypeConstraintForArrayConstraintsFromSetTypeConstraint($typeConstraint))) {
            throw new \InvalidArgumentException($typeConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($typeConstraint) || (is_array($typeConstraint) && empty($typeConstraint))) {
            unset($this->typeConstraint);
        } else {
            $this->typeConstraint = $typeConstraint;
        }
        return $this;
    }
    /**
     * Add item to typeConstraint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BusinessEventsRequest
     */
    public function addToTypeConstraint($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The typeConstraint property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->typeConstraint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEventsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
