<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEvent StructType
 * @subpackage Structs
 */
class BusinessEvent extends AbstractStructBase
{
    /**
     * The annotations
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Annotation[]
     */
    public $annotations;
    /**
     * The attachments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtendedAttachment[]
     */
    public $attachments;
    /**
     * The completionData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CompletionData
     */
    public $completionData;
    /**
     * The coreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CoreData
     */
    public $coreData;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The qualificationData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\QualificationData
     */
    public $qualificationData;
    /**
     * The remoteStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $remoteStatus;
    /**
     * The schedulingData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SchedulingData
     */
    public $schedulingData;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for businessEvent
     * @uses BusinessEvent::setAnnotations()
     * @uses BusinessEvent::setAttachments()
     * @uses BusinessEvent::setCompletionData()
     * @uses BusinessEvent::setCoreData()
     * @uses BusinessEvent::setExtensions()
     * @uses BusinessEvent::setId()
     * @uses BusinessEvent::setMessage()
     * @uses BusinessEvent::setQualificationData()
     * @uses BusinessEvent::setRemoteStatus()
     * @uses BusinessEvent::setSchedulingData()
     * @uses BusinessEvent::setStatus()
     * @param \StructType\Annotation[] $annotations
     * @param \StructType\ExtendedAttachment[] $attachments
     * @param \StructType\CompletionData $completionData
     * @param \StructType\CoreData $coreData
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $id
     * @param string $message
     * @param \StructType\QualificationData $qualificationData
     * @param string $remoteStatus
     * @param \StructType\SchedulingData $schedulingData
     * @param string $status
     */
    public function __construct(array $annotations = array(), array $attachments = array(), \StructType\CompletionData $completionData = null, \StructType\CoreData $coreData = null, array $extensions = array(), $id = null, $message = null, \StructType\QualificationData $qualificationData = null, $remoteStatus = null, \StructType\SchedulingData $schedulingData = null, $status = null)
    {
        $this
            ->setAnnotations($annotations)
            ->setAttachments($attachments)
            ->setCompletionData($completionData)
            ->setCoreData($coreData)
            ->setExtensions($extensions)
            ->setId($id)
            ->setMessage($message)
            ->setQualificationData($qualificationData)
            ->setRemoteStatus($remoteStatus)
            ->setSchedulingData($schedulingData)
            ->setStatus($status);
    }
    /**
     * Get annotations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Annotation[]|null
     */
    public function getAnnotations()
    {
        return isset($this->annotations) ? $this->annotations : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnnotations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnnotations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnnotationsForArrayConstraintsFromSetAnnotations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventAnnotationsItem) {
            // validation for constraint: itemType
            if (!$businessEventAnnotationsItem instanceof \StructType\Annotation) {
                $invalidValues[] = is_object($businessEventAnnotationsItem) ? get_class($businessEventAnnotationsItem) : sprintf('%s(%s)', gettype($businessEventAnnotationsItem), var_export($businessEventAnnotationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The annotations property can only contain items of type \StructType\Annotation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set annotations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Annotation[] $annotations
     * @return \StructType\BusinessEvent
     */
    public function setAnnotations(array $annotations = array())
    {
        // validation for constraint: array
        if ('' !== ($annotationsArrayErrorMessage = self::validateAnnotationsForArrayConstraintsFromSetAnnotations($annotations))) {
            throw new \InvalidArgumentException($annotationsArrayErrorMessage, __LINE__);
        }
        if (is_null($annotations) || (is_array($annotations) && empty($annotations))) {
            unset($this->annotations);
        } else {
            $this->annotations = $annotations;
        }
        return $this;
    }
    /**
     * Add item to annotations value
     * @throws \InvalidArgumentException
     * @param \StructType\Annotation $item
     * @return \StructType\BusinessEvent
     */
    public function addToAnnotations(\StructType\Annotation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Annotation) {
            throw new \InvalidArgumentException(sprintf('The annotations property can only contain items of type \StructType\Annotation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->annotations[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtendedAttachment[]|null
     */
    public function getAttachments()
    {
        return isset($this->attachments) ? $this->attachments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentsForArrayConstraintsFromSetAttachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventAttachmentsItem) {
            // validation for constraint: itemType
            if (!$businessEventAttachmentsItem instanceof \StructType\ExtendedAttachment) {
                $invalidValues[] = is_object($businessEventAttachmentsItem) ? get_class($businessEventAttachmentsItem) : sprintf('%s(%s)', gettype($businessEventAttachmentsItem), var_export($businessEventAttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachments property can only contain items of type \StructType\ExtendedAttachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedAttachment[] $attachments
     * @return \StructType\BusinessEvent
     */
    public function setAttachments(array $attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentsArrayErrorMessage = self::validateAttachmentsForArrayConstraintsFromSetAttachments($attachments))) {
            throw new \InvalidArgumentException($attachmentsArrayErrorMessage, __LINE__);
        }
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->attachments);
        } else {
            $this->attachments = $attachments;
        }
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedAttachment $item
     * @return \StructType\BusinessEvent
     */
    public function addToAttachments(\StructType\ExtendedAttachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtendedAttachment) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of type \StructType\ExtendedAttachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get completionData value
     * @return \StructType\CompletionData|null
     */
    public function getCompletionData()
    {
        return $this->completionData;
    }
    /**
     * Set completionData value
     * @param \StructType\CompletionData $completionData
     * @return \StructType\BusinessEvent
     */
    public function setCompletionData(\StructType\CompletionData $completionData = null)
    {
        $this->completionData = $completionData;
        return $this;
    }
    /**
     * Get coreData value
     * @return \StructType\CoreData|null
     */
    public function getCoreData()
    {
        return $this->coreData;
    }
    /**
     * Set coreData value
     * @param \StructType\CoreData $coreData
     * @return \StructType\BusinessEvent
     */
    public function setCoreData(\StructType\CoreData $coreData = null)
    {
        $this->coreData = $coreData;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventExtensionsItem) {
            // validation for constraint: itemType
            if (!$businessEventExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($businessEventExtensionsItem) ? get_class($businessEventExtensionsItem) : sprintf('%s(%s)', gettype($businessEventExtensionsItem), var_export($businessEventExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\BusinessEvent
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\BusinessEvent
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\BusinessEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\BusinessEvent
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get qualificationData value
     * @return \StructType\QualificationData|null
     */
    public function getQualificationData()
    {
        return $this->qualificationData;
    }
    /**
     * Set qualificationData value
     * @param \StructType\QualificationData $qualificationData
     * @return \StructType\BusinessEvent
     */
    public function setQualificationData(\StructType\QualificationData $qualificationData = null)
    {
        $this->qualificationData = $qualificationData;
        return $this;
    }
    /**
     * Get remoteStatus value
     * @return string|null
     */
    public function getRemoteStatus()
    {
        return $this->remoteStatus;
    }
    /**
     * Set remoteStatus value
     * @param string $remoteStatus
     * @return \StructType\BusinessEvent
     */
    public function setRemoteStatus($remoteStatus = null)
    {
        // validation for constraint: string
        if (!is_null($remoteStatus) && !is_string($remoteStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteStatus, true), gettype($remoteStatus)), __LINE__);
        }
        $this->remoteStatus = $remoteStatus;
        return $this;
    }
    /**
     * Get schedulingData value
     * @return \StructType\SchedulingData|null
     */
    public function getSchedulingData()
    {
        return $this->schedulingData;
    }
    /**
     * Set schedulingData value
     * @param \StructType\SchedulingData $schedulingData
     * @return \StructType\BusinessEvent
     */
    public function setSchedulingData(\StructType\SchedulingData $schedulingData = null)
    {
        $this->schedulingData = $schedulingData;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BusinessEvent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Status', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
