<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addAnnotation StructType
 * Meta information extracted from the WSDL
 * - type: tns:addAnnotation
 * @subpackage Structs
 */
class AddAnnotation extends AbstractStructBase
{
    /**
     * The businessEventId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $businessEventId;
    /**
     * The annotation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Annotation
     */
    public $annotation;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for addAnnotation
     * @uses AddAnnotation::setBusinessEventId()
     * @uses AddAnnotation::setAnnotation()
     * @uses AddAnnotation::setOptions()
     * @param string $businessEventId
     * @param \StructType\Annotation $annotation
     * @param \StructType\WsEntry[] $options
     */
    public function __construct($businessEventId = null, \StructType\Annotation $annotation = null, array $options = array())
    {
        $this
            ->setBusinessEventId($businessEventId)
            ->setAnnotation($annotation)
            ->setOptions($options);
    }
    /**
     * Get businessEventId value
     * @return string|null
     */
    public function getBusinessEventId()
    {
        return $this->businessEventId;
    }
    /**
     * Set businessEventId value
     * @param string $businessEventId
     * @return \StructType\AddAnnotation
     */
    public function setBusinessEventId($businessEventId = null)
    {
        // validation for constraint: string
        if (!is_null($businessEventId) && !is_string($businessEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessEventId, true), gettype($businessEventId)), __LINE__);
        }
        $this->businessEventId = $businessEventId;
        return $this;
    }
    /**
     * Get annotation value
     * @return \StructType\Annotation|null
     */
    public function getAnnotation()
    {
        return $this->annotation;
    }
    /**
     * Set annotation value
     * @param \StructType\Annotation $annotation
     * @return \StructType\AddAnnotation
     */
    public function setAnnotation(\StructType\Annotation $annotation = null)
    {
        $this->annotation = $annotation;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addAnnotationOptionsItem) {
            // validation for constraint: itemType
            if (!$addAnnotationOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($addAnnotationOptionsItem) ? get_class($addAnnotationOptionsItem) : sprintf('%s(%s)', gettype($addAnnotationOptionsItem), var_export($addAnnotationOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\AddAnnotation
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\AddAnnotation
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAnnotation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
