<?php

namespace EnumType;

/**
 * This class stands for quality EnumType
 * @subpackage Enumerations
 */
class Quality
{
    /**
     * Constant for value 'LOW'
     * @return string 'LOW'
     */
    const VALUE_LOW = 'LOW';
    /**
     * Constant for value 'MEDIUM'
     * @return string 'MEDIUM'
     */
    const VALUE_MEDIUM = 'MEDIUM';
    /**
     * Constant for value 'HIGH'
     * @return string 'HIGH'
     */
    const VALUE_HIGH = 'HIGH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOW
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_HIGH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOW,
            self::VALUE_MEDIUM,
            self::VALUE_HIGH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
