<?php

namespace EnumType;

/**
 * This class stands for instruction EnumType
 * @subpackage Enumerations
 */
class Instruction
{
    /**
     * Constant for value 'NO'
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Constant for value 'YES'
     * @return string 'YES'
     */
    const VALUE_YES = 'YES';
    /**
     * Constant for value 'STATIC'
     * @return string 'STATIC'
     */
    const VALUE_STATIC = 'STATIC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO
     * @uses self::VALUE_YES
     * @uses self::VALUE_STATIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO,
            self::VALUE_YES,
            self::VALUE_STATIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
