<?php

namespace EnumType;

/**
 * This class stands for geocodingMode EnumType
 * @subpackage Enumerations
 */
class GeocodingMode
{
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'OPTIONAL'
     * @return string 'OPTIONAL'
     */
    const VALUE_OPTIONAL = 'OPTIONAL';
    /**
     * Constant for value 'COMPULSORY'
     * @return string 'COMPULSORY'
     */
    const VALUE_COMPULSORY = 'COMPULSORY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_OPTIONAL
     * @uses self::VALUE_COMPULSORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_OPTIONAL,
            self::VALUE_COMPULSORY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
