<?php

namespace EnumType;

/**
 * This class stands for extendedReportFieldType EnumType
 * @subpackage Enumerations
 */
class ExtendedReportFieldType
{
    /**
     * Constant for value 'TEXT'
     * @return string 'TEXT'
     */
    const VALUE_TEXT = 'TEXT';
    /**
     * Constant for value 'DROP_DOWN'
     * @return string 'DROP_DOWN'
     */
    const VALUE_DROP_DOWN = 'DROP_DOWN';
    /**
     * Constant for value 'TEXTAREA'
     * @return string 'TEXTAREA'
     */
    const VALUE_TEXTAREA = 'TEXTAREA';
    /**
     * Constant for value 'CHECKBOX'
     * @return string 'CHECKBOX'
     */
    const VALUE_CHECKBOX = 'CHECKBOX';
    /**
     * Constant for value 'NUMERIC'
     * @return string 'NUMERIC'
     */
    const VALUE_NUMERIC = 'NUMERIC';
    /**
     * Constant for value 'BAR_CODE'
     * @return string 'BAR_CODE'
     */
    const VALUE_BAR_CODE = 'BAR_CODE';
    /**
     * Constant for value 'SIGNATURE'
     * @return string 'SIGNATURE'
     */
    const VALUE_SIGNATURE = 'SIGNATURE';
    /**
     * Constant for value 'PHOTO'
     * @return string 'PHOTO'
     */
    const VALUE_PHOTO = 'PHOTO';
    /**
     * Constant for value 'COMMENT'
     * @return string 'COMMENT'
     */
    const VALUE_COMMENT = 'COMMENT';
    /**
     * Constant for value 'GPS'
     * @return string 'GPS'
     */
    const VALUE_GPS = 'GPS';
    /**
     * Constant for value 'DATE'
     * @return string 'DATE'
     */
    const VALUE_DATE = 'DATE';
    /**
     * Constant for value 'TIME'
     * @return string 'TIME'
     */
    const VALUE_TIME = 'TIME';
    /**
     * Constant for value 'URL'
     * @return string 'URL'
     */
    const VALUE_URL = 'URL';
    /**
     * Constant for value 'PHONE'
     * @return string 'PHONE'
     */
    const VALUE_PHONE = 'PHONE';
    /**
     * Constant for value 'PAYMENT'
     * @return string 'PAYMENT'
     */
    const VALUE_PAYMENT = 'PAYMENT';
    /**
     * Constant for value 'MODULE'
     * @return string 'MODULE'
     */
    const VALUE_MODULE = 'MODULE';
    /**
     * Constant for value 'AUDIO'
     * @return string 'AUDIO'
     */
    const VALUE_AUDIO = 'AUDIO';
    /**
     * Constant for value 'VIDEO'
     * @return string 'VIDEO'
     */
    const VALUE_VIDEO = 'VIDEO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_DROP_DOWN
     * @uses self::VALUE_TEXTAREA
     * @uses self::VALUE_CHECKBOX
     * @uses self::VALUE_NUMERIC
     * @uses self::VALUE_BAR_CODE
     * @uses self::VALUE_SIGNATURE
     * @uses self::VALUE_PHOTO
     * @uses self::VALUE_COMMENT
     * @uses self::VALUE_GPS
     * @uses self::VALUE_DATE
     * @uses self::VALUE_TIME
     * @uses self::VALUE_URL
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_PAYMENT
     * @uses self::VALUE_MODULE
     * @uses self::VALUE_AUDIO
     * @uses self::VALUE_VIDEO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEXT,
            self::VALUE_DROP_DOWN,
            self::VALUE_TEXTAREA,
            self::VALUE_CHECKBOX,
            self::VALUE_NUMERIC,
            self::VALUE_BAR_CODE,
            self::VALUE_SIGNATURE,
            self::VALUE_PHOTO,
            self::VALUE_COMMENT,
            self::VALUE_GPS,
            self::VALUE_DATE,
            self::VALUE_TIME,
            self::VALUE_URL,
            self::VALUE_PHONE,
            self::VALUE_PAYMENT,
            self::VALUE_MODULE,
            self::VALUE_AUDIO,
            self::VALUE_VIDEO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
