<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tableSection StructType
 * @subpackage Structs
 */
class TableSection extends ReportElement
{
    /**
     * The rows
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RowSection[]
     */
    public $rows;
    /**
     * Constructor method for tableSection
     * @uses TableSection::setRows()
     * @param \StructType\RowSection[] $rows
     */
    public function __construct(array $rows = array())
    {
        $this
            ->setRows($rows);
    }
    /**
     * Get rows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RowSection[]|null
     */
    public function getRows()
    {
        return isset($this->rows) ? $this->rows : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRows method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRows method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowsForArrayConstraintsFromSetRows(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tableSectionRowsItem) {
            // validation for constraint: itemType
            if (!$tableSectionRowsItem instanceof \StructType\RowSection) {
                $invalidValues[] = is_object($tableSectionRowsItem) ? get_class($tableSectionRowsItem) : sprintf('%s(%s)', gettype($tableSectionRowsItem), var_export($tableSectionRowsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rows property can only contain items of type \StructType\RowSection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RowSection[] $rows
     * @return \StructType\TableSection
     */
    public function setRows(array $rows = array())
    {
        // validation for constraint: array
        if ('' !== ($rowsArrayErrorMessage = self::validateRowsForArrayConstraintsFromSetRows($rows))) {
            throw new \InvalidArgumentException($rowsArrayErrorMessage, __LINE__);
        }
        if (is_null($rows) || (is_array($rows) && empty($rows))) {
            unset($this->rows);
        } else {
            $this->rows = $rows;
        }
        return $this;
    }
    /**
     * Add item to rows value
     * @throws \InvalidArgumentException
     * @param \StructType\RowSection $item
     * @return \StructType\TableSection
     */
    public function addToRows(\StructType\RowSection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RowSection) {
            throw new \InvalidArgumentException(sprintf('The rows property can only contain items of type \StructType\RowSection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rows[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TableSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
