<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceOrderConstraint StructType
 * @subpackage Structs
 */
class ServiceOrderConstraint extends AbstractStructBase
{
    /**
     * The idConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $idConstraint;
    /**
     * The linkedConstraint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $linkedConstraint;
    /**
     * The statusConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $statusConstraint;
    /**
     * The typeConstraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $typeConstraint;
    /**
     * Constructor method for serviceOrderConstraint
     * @uses ServiceOrderConstraint::setIdConstraint()
     * @uses ServiceOrderConstraint::setLinkedConstraint()
     * @uses ServiceOrderConstraint::setStatusConstraint()
     * @uses ServiceOrderConstraint::setTypeConstraint()
     * @param string[] $idConstraint
     * @param bool $linkedConstraint
     * @param string[] $statusConstraint
     * @param string[] $typeConstraint
     */
    public function __construct(array $idConstraint = array(), $linkedConstraint = null, array $statusConstraint = array(), array $typeConstraint = array())
    {
        $this
            ->setIdConstraint($idConstraint)
            ->setLinkedConstraint($linkedConstraint)
            ->setStatusConstraint($statusConstraint)
            ->setTypeConstraint($typeConstraint);
    }
    /**
     * Get idConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getIdConstraint()
    {
        return isset($this->idConstraint) ? $this->idConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdConstraintForArrayConstraintsFromSetIdConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOrderConstraintIdConstraintItem) {
            // validation for constraint: itemType
            if (!is_string($serviceOrderConstraintIdConstraintItem)) {
                $invalidValues[] = is_object($serviceOrderConstraintIdConstraintItem) ? get_class($serviceOrderConstraintIdConstraintItem) : sprintf('%s(%s)', gettype($serviceOrderConstraintIdConstraintItem), var_export($serviceOrderConstraintIdConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idConstraint property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $idConstraint
     * @return \StructType\ServiceOrderConstraint
     */
    public function setIdConstraint(array $idConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($idConstraintArrayErrorMessage = self::validateIdConstraintForArrayConstraintsFromSetIdConstraint($idConstraint))) {
            throw new \InvalidArgumentException($idConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($idConstraint) || (is_array($idConstraint) && empty($idConstraint))) {
            unset($this->idConstraint);
        } else {
            $this->idConstraint = $idConstraint;
        }
        return $this;
    }
    /**
     * Add item to idConstraint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceOrderConstraint
     */
    public function addToIdConstraint($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The idConstraint property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idConstraint[] = $item;
        return $this;
    }
    /**
     * Get linkedConstraint value
     * @return bool|null
     */
    public function getLinkedConstraint()
    {
        return $this->linkedConstraint;
    }
    /**
     * Set linkedConstraint value
     * @param bool $linkedConstraint
     * @return \StructType\ServiceOrderConstraint
     */
    public function setLinkedConstraint($linkedConstraint = null)
    {
        // validation for constraint: boolean
        if (!is_null($linkedConstraint) && !is_bool($linkedConstraint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($linkedConstraint, true), gettype($linkedConstraint)), __LINE__);
        }
        $this->linkedConstraint = $linkedConstraint;
        return $this;
    }
    /**
     * Get statusConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStatusConstraint()
    {
        return isset($this->statusConstraint) ? $this->statusConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusConstraintForArrayConstraintsFromSetStatusConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOrderConstraintStatusConstraintItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ServiceOrderStatus::valueIsValid($serviceOrderConstraintStatusConstraintItem)) {
                $invalidValues[] = is_object($serviceOrderConstraintStatusConstraintItem) ? get_class($serviceOrderConstraintStatusConstraintItem) : sprintf('%s(%s)', gettype($serviceOrderConstraintStatusConstraintItem), var_export($serviceOrderConstraintStatusConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceOrderStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ServiceOrderStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statusConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ServiceOrderStatus::valueIsValid()
     * @uses \EnumType\ServiceOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusConstraint
     * @return \StructType\ServiceOrderConstraint
     */
    public function setStatusConstraint(array $statusConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($statusConstraintArrayErrorMessage = self::validateStatusConstraintForArrayConstraintsFromSetStatusConstraint($statusConstraint))) {
            throw new \InvalidArgumentException($statusConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($statusConstraint) || (is_array($statusConstraint) && empty($statusConstraint))) {
            unset($this->statusConstraint);
        } else {
            $this->statusConstraint = $statusConstraint;
        }
        return $this;
    }
    /**
     * Add item to statusConstraint value
     * @uses \EnumType\ServiceOrderStatus::valueIsValid()
     * @uses \EnumType\ServiceOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceOrderConstraint
     */
    public function addToStatusConstraint($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceOrderStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceOrderStatus', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ServiceOrderStatus::getValidValues())), __LINE__);
        }
        $this->statusConstraint[] = $item;
        return $this;
    }
    /**
     * Get typeConstraint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTypeConstraint()
    {
        return isset($this->typeConstraint) ? $this->typeConstraint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeConstraintForArrayConstraintsFromSetTypeConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOrderConstraintTypeConstraintItem) {
            // validation for constraint: itemType
            if (!is_string($serviceOrderConstraintTypeConstraintItem)) {
                $invalidValues[] = is_object($serviceOrderConstraintTypeConstraintItem) ? get_class($serviceOrderConstraintTypeConstraintItem) : sprintf('%s(%s)', gettype($serviceOrderConstraintTypeConstraintItem), var_export($serviceOrderConstraintTypeConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The typeConstraint property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set typeConstraint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $typeConstraint
     * @return \StructType\ServiceOrderConstraint
     */
    public function setTypeConstraint(array $typeConstraint = array())
    {
        // validation for constraint: array
        if ('' !== ($typeConstraintArrayErrorMessage = self::validateTypeConstraintForArrayConstraintsFromSetTypeConstraint($typeConstraint))) {
            throw new \InvalidArgumentException($typeConstraintArrayErrorMessage, __LINE__);
        }
        if (is_null($typeConstraint) || (is_array($typeConstraint) && empty($typeConstraint))) {
            unset($this->typeConstraint);
        } else {
            $this->typeConstraint = $typeConstraint;
        }
        return $this;
    }
    /**
     * Add item to typeConstraint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceOrderConstraint
     */
    public function addToTypeConstraint($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The typeConstraint property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->typeConstraint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceOrderConstraint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
