<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchEvents StructType
 * Meta information extracted from the WSDL
 * - type: tns:searchEvents
 * @subpackage Structs
 */
class SearchEvents extends AbstractStructBase
{
    /**
     * The request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessEventsRequest
     */
    public $request;
    /**
     * The batchSize
     * @var int
     */
    public $batchSize;
    /**
     * The firstResultIndex
     * @var int
     */
    public $firstResultIndex;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * Constructor method for searchEvents
     * @uses SearchEvents::setRequest()
     * @uses SearchEvents::setBatchSize()
     * @uses SearchEvents::setFirstResultIndex()
     * @uses SearchEvents::setOptions()
     * @param \StructType\BusinessEventsRequest $request
     * @param int $batchSize
     * @param int $firstResultIndex
     * @param \StructType\WsEntry[] $options
     */
    public function __construct(\StructType\BusinessEventsRequest $request = null, $batchSize = null, $firstResultIndex = null, array $options = array())
    {
        $this
            ->setRequest($request)
            ->setBatchSize($batchSize)
            ->setFirstResultIndex($firstResultIndex)
            ->setOptions($options);
    }
    /**
     * Get request value
     * @return \StructType\BusinessEventsRequest|null
     */
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * Set request value
     * @param \StructType\BusinessEventsRequest $request
     * @return \StructType\SearchEvents
     */
    public function setRequest(\StructType\BusinessEventsRequest $request = null)
    {
        $this->request = $request;
        return $this;
    }
    /**
     * Get batchSize value
     * @return int|null
     */
    public function getBatchSize()
    {
        return $this->batchSize;
    }
    /**
     * Set batchSize value
     * @param int $batchSize
     * @return \StructType\SearchEvents
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !(is_int($batchSize) || ctype_digit($batchSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchSize, true), gettype($batchSize)), __LINE__);
        }
        $this->batchSize = $batchSize;
        return $this;
    }
    /**
     * Get firstResultIndex value
     * @return int|null
     */
    public function getFirstResultIndex()
    {
        return $this->firstResultIndex;
    }
    /**
     * Set firstResultIndex value
     * @param int $firstResultIndex
     * @return \StructType\SearchEvents
     */
    public function setFirstResultIndex($firstResultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($firstResultIndex) && !(is_int($firstResultIndex) || ctype_digit($firstResultIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstResultIndex, true), gettype($firstResultIndex)), __LINE__);
        }
        $this->firstResultIndex = $firstResultIndex;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchEventsOptionsItem) {
            // validation for constraint: itemType
            if (!$searchEventsOptionsItem instanceof \StructType\WsEntry) {
                $invalidValues[] = is_object($searchEventsOptionsItem) ? get_class($searchEventsOptionsItem) : sprintf('%s(%s)', gettype($searchEventsOptionsItem), var_export($searchEventsOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\SearchEvents
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: array
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\SearchEvents
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of type \StructType\WsEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchEvents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
