<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportField StructType
 * @subpackage Structs
 */
class ReportField extends ReportElement
{
    /**
     * The binaryData
     * Meta information extracted from the WSDL
     * - expectedContentTypes: application/octet-stream
     * - minOccurs: 0
     * @var string
     */
    public $binaryData;
    /**
     * The fillingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fillingDate;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The valueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valueCode;
    /**
     * Constructor method for reportField
     * @uses ReportField::setBinaryData()
     * @uses ReportField::setFillingDate()
     * @uses ReportField::setValue()
     * @uses ReportField::setValueCode()
     * @param string $binaryData
     * @param string $fillingDate
     * @param string $value
     * @param string $valueCode
     */
    public function __construct($binaryData = null, $fillingDate = null, $value = null, $valueCode = null)
    {
        $this
            ->setBinaryData($binaryData)
            ->setFillingDate($fillingDate)
            ->setValue($value)
            ->setValueCode($valueCode);
    }
    /**
     * Get binaryData value
     * @return string|null
     */
    public function getBinaryData()
    {
        return $this->binaryData;
    }
    /**
     * Set binaryData value
     * @param string $binaryData
     * @return \StructType\ReportField
     */
    public function setBinaryData($binaryData = null)
    {
        // validation for constraint: string
        if (!is_null($binaryData) && !is_string($binaryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binaryData, true), gettype($binaryData)), __LINE__);
        }
        $this->binaryData = $binaryData;
        return $this;
    }
    /**
     * Get fillingDate value
     * @return string|null
     */
    public function getFillingDate()
    {
        return $this->fillingDate;
    }
    /**
     * Set fillingDate value
     * @param string $fillingDate
     * @return \StructType\ReportField
     */
    public function setFillingDate($fillingDate = null)
    {
        // validation for constraint: string
        if (!is_null($fillingDate) && !is_string($fillingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fillingDate, true), gettype($fillingDate)), __LINE__);
        }
        $this->fillingDate = $fillingDate;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\ReportField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get valueCode value
     * @return string|null
     */
    public function getValueCode()
    {
        return $this->valueCode;
    }
    /**
     * Set valueCode value
     * @param string $valueCode
     * @return \StructType\ReportField
     */
    public function setValueCode($valueCode = null)
    {
        // validation for constraint: string
        if (!is_null($valueCode) && !is_string($valueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueCode, true), gettype($valueCode)), __LINE__);
        }
        $this->valueCode = $valueCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
