<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for qualificationData StructType
 * @subpackage Structs
 */
class QualificationData extends AbstractStructBase
{
    /**
     * The expectedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtendedItem[]
     */
    public $expectedItems;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReportElement[]
     */
    public $instructions;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessEventType
     */
    public $type;
    /**
     * Constructor method for qualificationData
     * @uses QualificationData::setExpectedItems()
     * @uses QualificationData::setExtensions()
     * @uses QualificationData::setInstructions()
     * @uses QualificationData::setType()
     * @param \StructType\ExtendedItem[] $expectedItems
     * @param \StructType\WsValuedEntry[] $extensions
     * @param \StructType\ReportElement[] $instructions
     * @param \StructType\BusinessEventType $type
     */
    public function __construct(array $expectedItems = array(), array $extensions = array(), array $instructions = array(), \StructType\BusinessEventType $type = null)
    {
        $this
            ->setExpectedItems($expectedItems)
            ->setExtensions($extensions)
            ->setInstructions($instructions)
            ->setType($type);
    }
    /**
     * Get expectedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtendedItem[]|null
     */
    public function getExpectedItems()
    {
        return isset($this->expectedItems) ? $this->expectedItems : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedItemsForArrayConstraintsFromSetExpectedItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualificationDataExpectedItemsItem) {
            // validation for constraint: itemType
            if (!$qualificationDataExpectedItemsItem instanceof \StructType\ExtendedItem) {
                $invalidValues[] = is_object($qualificationDataExpectedItemsItem) ? get_class($qualificationDataExpectedItemsItem) : sprintf('%s(%s)', gettype($qualificationDataExpectedItemsItem), var_export($qualificationDataExpectedItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expectedItems property can only contain items of type \StructType\ExtendedItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expectedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedItem[] $expectedItems
     * @return \StructType\QualificationData
     */
    public function setExpectedItems(array $expectedItems = array())
    {
        // validation for constraint: array
        if ('' !== ($expectedItemsArrayErrorMessage = self::validateExpectedItemsForArrayConstraintsFromSetExpectedItems($expectedItems))) {
            throw new \InvalidArgumentException($expectedItemsArrayErrorMessage, __LINE__);
        }
        if (is_null($expectedItems) || (is_array($expectedItems) && empty($expectedItems))) {
            unset($this->expectedItems);
        } else {
            $this->expectedItems = $expectedItems;
        }
        return $this;
    }
    /**
     * Add item to expectedItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedItem $item
     * @return \StructType\QualificationData
     */
    public function addToExpectedItems(\StructType\ExtendedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtendedItem) {
            throw new \InvalidArgumentException(sprintf('The expectedItems property can only contain items of type \StructType\ExtendedItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expectedItems[] = $item;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualificationDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$qualificationDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($qualificationDataExtensionsItem) ? get_class($qualificationDataExtensionsItem) : sprintf('%s(%s)', gettype($qualificationDataExtensionsItem), var_export($qualificationDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\QualificationData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\QualificationData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get instructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReportElement[]|null
     */
    public function getInstructions()
    {
        return isset($this->instructions) ? $this->instructions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionsForArrayConstraintsFromSetInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $qualificationDataInstructionsItem) {
            // validation for constraint: itemType
            if (!$qualificationDataInstructionsItem instanceof \StructType\ReportElement) {
                $invalidValues[] = is_object($qualificationDataInstructionsItem) ? get_class($qualificationDataInstructionsItem) : sprintf('%s(%s)', gettype($qualificationDataInstructionsItem), var_export($qualificationDataInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The instructions property can only contain items of type \StructType\ReportElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set instructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReportElement[] $instructions
     * @return \StructType\QualificationData
     */
    public function setInstructions(array $instructions = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionsArrayErrorMessage = self::validateInstructionsForArrayConstraintsFromSetInstructions($instructions))) {
            throw new \InvalidArgumentException($instructionsArrayErrorMessage, __LINE__);
        }
        if (is_null($instructions) || (is_array($instructions) && empty($instructions))) {
            unset($this->instructions);
        } else {
            $this->instructions = $instructions;
        }
        return $this;
    }
    /**
     * Add item to instructions value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportElement $item
     * @return \StructType\QualificationData
     */
    public function addToInstructions(\StructType\ReportElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReportElement) {
            throw new \InvalidArgumentException(sprintf('The instructions property can only contain items of type \StructType\ReportElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->instructions[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return \StructType\BusinessEventType|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param \StructType\BusinessEventType $type
     * @return \StructType\QualificationData
     */
    public function setType(\StructType\BusinessEventType $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QualificationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
