<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for praxedoReferentialData StructType
 * @subpackage Structs
 */
class PraxedoReferentialData extends ReferentialData
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The equipmentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $equipmentId;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The geolocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Geolocation
     */
    public $geolocation;
    /**
     * The locationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locationId;
    /**
     * Constructor method for praxedoReferentialData
     * @uses PraxedoReferentialData::setCustomerId()
     * @uses PraxedoReferentialData::setEquipmentId()
     * @uses PraxedoReferentialData::setExtensions()
     * @uses PraxedoReferentialData::setGeolocation()
     * @uses PraxedoReferentialData::setLocationId()
     * @param string $customerId
     * @param string $equipmentId
     * @param \StructType\WsValuedEntry[] $extensions
     * @param \StructType\Geolocation $geolocation
     * @param string $locationId
     */
    public function __construct($customerId = null, $equipmentId = null, array $extensions = array(), \StructType\Geolocation $geolocation = null, $locationId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setEquipmentId($equipmentId)
            ->setExtensions($extensions)
            ->setGeolocation($geolocation)
            ->setLocationId($locationId);
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \StructType\PraxedoReferentialData
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get equipmentId value
     * @return string|null
     */
    public function getEquipmentId()
    {
        return $this->equipmentId;
    }
    /**
     * Set equipmentId value
     * @param string $equipmentId
     * @return \StructType\PraxedoReferentialData
     */
    public function setEquipmentId($equipmentId = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentId) && !is_string($equipmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentId, true), gettype($equipmentId)), __LINE__);
        }
        $this->equipmentId = $equipmentId;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $praxedoReferentialDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$praxedoReferentialDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($praxedoReferentialDataExtensionsItem) ? get_class($praxedoReferentialDataExtensionsItem) : sprintf('%s(%s)', gettype($praxedoReferentialDataExtensionsItem), var_export($praxedoReferentialDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\PraxedoReferentialData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\PraxedoReferentialData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get geolocation value
     * @return \StructType\Geolocation|null
     */
    public function getGeolocation()
    {
        return $this->geolocation;
    }
    /**
     * Set geolocation value
     * @param \StructType\Geolocation $geolocation
     * @return \StructType\PraxedoReferentialData
     */
    public function setGeolocation(\StructType\Geolocation $geolocation = null)
    {
        $this->geolocation = $geolocation;
        return $this;
    }
    /**
     * Get locationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param string $locationId
     * @return \StructType\PraxedoReferentialData
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PraxedoReferentialData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
