<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportSection StructType
 * @subpackage Structs
 */
class ExtendedReportSection extends ExtendedReportElement
{
    /**
     * The billingSectionPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billingSectionPosition;
    /**
     * The compulsory
     * @var bool
     */
    public $compulsory;
    /**
     * The contextual
     * @var bool
     */
    public $contextual;
    /**
     * The editable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $editable;
    /**
     * The elements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtendedReportElement[]
     */
    public $elements;
    /**
     * The fixedSize
     * @var bool
     */
    public $fixedSize;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for extendedReportSection
     * @uses ExtendedReportSection::setBillingSectionPosition()
     * @uses ExtendedReportSection::setCompulsory()
     * @uses ExtendedReportSection::setContextual()
     * @uses ExtendedReportSection::setEditable()
     * @uses ExtendedReportSection::setElements()
     * @uses ExtendedReportSection::setFixedSize()
     * @uses ExtendedReportSection::setType()
     * @param string $billingSectionPosition
     * @param bool $compulsory
     * @param bool $contextual
     * @param string $editable
     * @param \StructType\ExtendedReportElement[] $elements
     * @param bool $fixedSize
     * @param string $type
     */
    public function __construct($billingSectionPosition = null, $compulsory = null, $contextual = null, $editable = null, array $elements = array(), $fixedSize = null, $type = null)
    {
        $this
            ->setBillingSectionPosition($billingSectionPosition)
            ->setCompulsory($compulsory)
            ->setContextual($contextual)
            ->setEditable($editable)
            ->setElements($elements)
            ->setFixedSize($fixedSize)
            ->setType($type);
    }
    /**
     * Get billingSectionPosition value
     * @return string|null
     */
    public function getBillingSectionPosition()
    {
        return $this->billingSectionPosition;
    }
    /**
     * Set billingSectionPosition value
     * @uses \EnumType\BillingSectionPosition::valueIsValid()
     * @uses \EnumType\BillingSectionPosition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingSectionPosition
     * @return \StructType\ExtendedReportSection
     */
    public function setBillingSectionPosition($billingSectionPosition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BillingSectionPosition::valueIsValid($billingSectionPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BillingSectionPosition', is_array($billingSectionPosition) ? implode(', ', $billingSectionPosition) : var_export($billingSectionPosition, true), implode(', ', \EnumType\BillingSectionPosition::getValidValues())), __LINE__);
        }
        $this->billingSectionPosition = $billingSectionPosition;
        return $this;
    }
    /**
     * Get compulsory value
     * @return bool|null
     */
    public function getCompulsory()
    {
        return $this->compulsory;
    }
    /**
     * Set compulsory value
     * @param bool $compulsory
     * @return \StructType\ExtendedReportSection
     */
    public function setCompulsory($compulsory = null)
    {
        // validation for constraint: boolean
        if (!is_null($compulsory) && !is_bool($compulsory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compulsory, true), gettype($compulsory)), __LINE__);
        }
        $this->compulsory = $compulsory;
        return $this;
    }
    /**
     * Get contextual value
     * @return bool|null
     */
    public function getContextual()
    {
        return $this->contextual;
    }
    /**
     * Set contextual value
     * @param bool $contextual
     * @return \StructType\ExtendedReportSection
     */
    public function setContextual($contextual = null)
    {
        // validation for constraint: boolean
        if (!is_null($contextual) && !is_bool($contextual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contextual, true), gettype($contextual)), __LINE__);
        }
        $this->contextual = $contextual;
        return $this;
    }
    /**
     * Get editable value
     * @return string|null
     */
    public function getEditable()
    {
        return $this->editable;
    }
    /**
     * Set editable value
     * @uses \EnumType\Editable::valueIsValid()
     * @uses \EnumType\Editable::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editable
     * @return \StructType\ExtendedReportSection
     */
    public function setEditable($editable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Editable::valueIsValid($editable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Editable', is_array($editable) ? implode(', ', $editable) : var_export($editable, true), implode(', ', \EnumType\Editable::getValidValues())), __LINE__);
        }
        $this->editable = $editable;
        return $this;
    }
    /**
     * Get elements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtendedReportElement[]|null
     */
    public function getElements()
    {
        return isset($this->elements) ? $this->elements : null;
    }
    /**
     * This method is responsible for validating the values passed to the setElements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementsForArrayConstraintsFromSetElements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedReportSectionElementsItem) {
            // validation for constraint: itemType
            if (!$extendedReportSectionElementsItem instanceof \StructType\ExtendedReportElement) {
                $invalidValues[] = is_object($extendedReportSectionElementsItem) ? get_class($extendedReportSectionElementsItem) : sprintf('%s(%s)', gettype($extendedReportSectionElementsItem), var_export($extendedReportSectionElementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The elements property can only contain items of type \StructType\ExtendedReportElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set elements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedReportElement[] $elements
     * @return \StructType\ExtendedReportSection
     */
    public function setElements(array $elements = array())
    {
        // validation for constraint: array
        if ('' !== ($elementsArrayErrorMessage = self::validateElementsForArrayConstraintsFromSetElements($elements))) {
            throw new \InvalidArgumentException($elementsArrayErrorMessage, __LINE__);
        }
        if (is_null($elements) || (is_array($elements) && empty($elements))) {
            unset($this->elements);
        } else {
            $this->elements = $elements;
        }
        return $this;
    }
    /**
     * Add item to elements value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtendedReportElement $item
     * @return \StructType\ExtendedReportSection
     */
    public function addToElements(\StructType\ExtendedReportElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtendedReportElement) {
            throw new \InvalidArgumentException(sprintf('The elements property can only contain items of type \StructType\ExtendedReportElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->elements[] = $item;
        return $this;
    }
    /**
     * Get fixedSize value
     * @return bool|null
     */
    public function getFixedSize()
    {
        return $this->fixedSize;
    }
    /**
     * Set fixedSize value
     * @param bool $fixedSize
     * @return \StructType\ExtendedReportSection
     */
    public function setFixedSize($fixedSize = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedSize) && !is_bool($fixedSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedSize, true), gettype($fixedSize)), __LINE__);
        }
        $this->fixedSize = $fixedSize;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ExtendedReportSectionType::valueIsValid()
     * @uses \EnumType\ExtendedReportSectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ExtendedReportSection
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExtendedReportSectionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExtendedReportSectionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ExtendedReportSectionType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
