<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportFieldPhoto StructType
 * @subpackage Structs
 */
class ExtendedReportFieldPhoto extends ExtendedReportField
{
    /**
     * The annotatable
     * @var bool
     */
    public $annotatable;
    /**
     * The geocodingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geocodingMode;
    /**
     * The quality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quality;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * Constructor method for extendedReportFieldPhoto
     * @uses ExtendedReportFieldPhoto::setAnnotatable()
     * @uses ExtendedReportFieldPhoto::setGeocodingMode()
     * @uses ExtendedReportFieldPhoto::setQuality()
     * @uses ExtendedReportFieldPhoto::setSource()
     * @param bool $annotatable
     * @param string $geocodingMode
     * @param string $quality
     * @param string $source
     */
    public function __construct($annotatable = null, $geocodingMode = null, $quality = null, $source = null)
    {
        $this
            ->setAnnotatable($annotatable)
            ->setGeocodingMode($geocodingMode)
            ->setQuality($quality)
            ->setSource($source);
    }
    /**
     * Get annotatable value
     * @return bool|null
     */
    public function getAnnotatable()
    {
        return $this->annotatable;
    }
    /**
     * Set annotatable value
     * @param bool $annotatable
     * @return \StructType\ExtendedReportFieldPhoto
     */
    public function setAnnotatable($annotatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($annotatable) && !is_bool($annotatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($annotatable, true), gettype($annotatable)), __LINE__);
        }
        $this->annotatable = $annotatable;
        return $this;
    }
    /**
     * Get geocodingMode value
     * @return string|null
     */
    public function getGeocodingMode()
    {
        return $this->geocodingMode;
    }
    /**
     * Set geocodingMode value
     * @uses \EnumType\GeocodingMode::valueIsValid()
     * @uses \EnumType\GeocodingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geocodingMode
     * @return \StructType\ExtendedReportFieldPhoto
     */
    public function setGeocodingMode($geocodingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeocodingMode::valueIsValid($geocodingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GeocodingMode', is_array($geocodingMode) ? implode(', ', $geocodingMode) : var_export($geocodingMode, true), implode(', ', \EnumType\GeocodingMode::getValidValues())), __LINE__);
        }
        $this->geocodingMode = $geocodingMode;
        return $this;
    }
    /**
     * Get quality value
     * @return string|null
     */
    public function getQuality()
    {
        return $this->quality;
    }
    /**
     * Set quality value
     * @uses \EnumType\Quality::valueIsValid()
     * @uses \EnumType\Quality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quality
     * @return \StructType\ExtendedReportFieldPhoto
     */
    public function setQuality($quality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Quality::valueIsValid($quality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Quality', is_array($quality) ? implode(', ', $quality) : var_export($quality, true), implode(', ', \EnumType\Quality::getValidValues())), __LINE__);
        }
        $this->quality = $quality;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @uses \EnumType\Source::valueIsValid()
     * @uses \EnumType\Source::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\ExtendedReportFieldPhoto
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Source::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Source', is_array($source) ? implode(', ', $source) : var_export($source, true), implode(', ', \EnumType\Source::getValidValues())), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportFieldPhoto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
