<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedReportFieldDropDownMenu StructType
 * @subpackage Structs
 */
class ExtendedReportFieldDropDownMenu extends ExtendedReportField
{
    /**
     * The authorizedValues
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $authorizedValues;
    /**
     * Constructor method for extendedReportFieldDropDownMenu
     * @uses ExtendedReportFieldDropDownMenu::setAuthorizedValues()
     * @param string[] $authorizedValues
     */
    public function __construct(array $authorizedValues = array())
    {
        $this
            ->setAuthorizedValues($authorizedValues);
    }
    /**
     * Get authorizedValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAuthorizedValues()
    {
        return isset($this->authorizedValues) ? $this->authorizedValues : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorizedValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizedValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizedValuesForArrayConstraintsFromSetAuthorizedValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedReportFieldDropDownMenuAuthorizedValuesItem) {
            // validation for constraint: itemType
            if (!is_string($extendedReportFieldDropDownMenuAuthorizedValuesItem)) {
                $invalidValues[] = is_object($extendedReportFieldDropDownMenuAuthorizedValuesItem) ? get_class($extendedReportFieldDropDownMenuAuthorizedValuesItem) : sprintf('%s(%s)', gettype($extendedReportFieldDropDownMenuAuthorizedValuesItem), var_export($extendedReportFieldDropDownMenuAuthorizedValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The authorizedValues property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set authorizedValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $authorizedValues
     * @return \StructType\ExtendedReportFieldDropDownMenu
     */
    public function setAuthorizedValues(array $authorizedValues = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizedValuesArrayErrorMessage = self::validateAuthorizedValuesForArrayConstraintsFromSetAuthorizedValues($authorizedValues))) {
            throw new \InvalidArgumentException($authorizedValuesArrayErrorMessage, __LINE__);
        }
        if (is_null($authorizedValues) || (is_array($authorizedValues) && empty($authorizedValues))) {
            unset($this->authorizedValues);
        } else {
            $this->authorizedValues = $authorizedValues;
        }
        return $this;
    }
    /**
     * Add item to authorizedValues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExtendedReportFieldDropDownMenu
     */
    public function addToAuthorizedValues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The authorizedValues property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->authorizedValues[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedReportFieldDropDownMenu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
