<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for coreData StructType
 * @subpackage Structs
 */
class CoreData extends AbstractStructBase
{
    /**
     * The anomaly
     * @var bool
     */
    public $anomaly;
    /**
     * The contacts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact[]
     */
    public $contacts;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creationDate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The earliestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $earliestDate;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The orderingCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderingCustomer;
    /**
     * The organizationalUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $organizationalUnitId;
    /**
     * The parentBusinessEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parentBusinessEvent;
    /**
     * The priority
     * @var int
     */
    public $priority;
    /**
     * The referentialData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferentialData
     */
    public $referentialData;
    /**
     * The serviceOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceOrder
     */
    public $serviceOrder;
    /**
     * Constructor method for coreData
     * @uses CoreData::setAnomaly()
     * @uses CoreData::setContacts()
     * @uses CoreData::setCreationDate()
     * @uses CoreData::setDescription()
     * @uses CoreData::setEarliestDate()
     * @uses CoreData::setExpirationDate()
     * @uses CoreData::setExtensions()
     * @uses CoreData::setOrderingCustomer()
     * @uses CoreData::setOrganizationalUnitId()
     * @uses CoreData::setParentBusinessEvent()
     * @uses CoreData::setPriority()
     * @uses CoreData::setReferentialData()
     * @uses CoreData::setServiceOrder()
     * @param bool $anomaly
     * @param \StructType\Contact[] $contacts
     * @param string $creationDate
     * @param string $description
     * @param string $earliestDate
     * @param string $expirationDate
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $orderingCustomer
     * @param string $organizationalUnitId
     * @param string $parentBusinessEvent
     * @param int $priority
     * @param \StructType\ReferentialData $referentialData
     * @param \StructType\ServiceOrder $serviceOrder
     */
    public function __construct($anomaly = null, array $contacts = array(), $creationDate = null, $description = null, $earliestDate = null, $expirationDate = null, array $extensions = array(), $orderingCustomer = null, $organizationalUnitId = null, $parentBusinessEvent = null, $priority = null, \StructType\ReferentialData $referentialData = null, \StructType\ServiceOrder $serviceOrder = null)
    {
        $this
            ->setAnomaly($anomaly)
            ->setContacts($contacts)
            ->setCreationDate($creationDate)
            ->setDescription($description)
            ->setEarliestDate($earliestDate)
            ->setExpirationDate($expirationDate)
            ->setExtensions($extensions)
            ->setOrderingCustomer($orderingCustomer)
            ->setOrganizationalUnitId($organizationalUnitId)
            ->setParentBusinessEvent($parentBusinessEvent)
            ->setPriority($priority)
            ->setReferentialData($referentialData)
            ->setServiceOrder($serviceOrder);
    }
    /**
     * Get anomaly value
     * @return bool|null
     */
    public function getAnomaly()
    {
        return $this->anomaly;
    }
    /**
     * Set anomaly value
     * @param bool $anomaly
     * @return \StructType\CoreData
     */
    public function setAnomaly($anomaly = null)
    {
        // validation for constraint: boolean
        if (!is_null($anomaly) && !is_bool($anomaly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anomaly, true), gettype($anomaly)), __LINE__);
        }
        $this->anomaly = $anomaly;
        return $this;
    }
    /**
     * Get contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact[]|null
     */
    public function getContacts()
    {
        return isset($this->contacts) ? $this->contacts : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContacts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContacts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactsForArrayConstraintsFromSetContacts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coreDataContactsItem) {
            // validation for constraint: itemType
            if (!$coreDataContactsItem instanceof \StructType\Contact) {
                $invalidValues[] = is_object($coreDataContactsItem) ? get_class($coreDataContactsItem) : sprintf('%s(%s)', gettype($coreDataContactsItem), var_export($coreDataContactsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contacts property can only contain items of type \StructType\Contact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contact[] $contacts
     * @return \StructType\CoreData
     */
    public function setContacts(array $contacts = array())
    {
        // validation for constraint: array
        if ('' !== ($contactsArrayErrorMessage = self::validateContactsForArrayConstraintsFromSetContacts($contacts))) {
            throw new \InvalidArgumentException($contactsArrayErrorMessage, __LINE__);
        }
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->contacts);
        } else {
            $this->contacts = $contacts;
        }
        return $this;
    }
    /**
     * Add item to contacts value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact $item
     * @return \StructType\CoreData
     */
    public function addToContacts(\StructType\Contact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contact) {
            throw new \InvalidArgumentException(sprintf('The contacts property can only contain items of type \StructType\Contact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contacts[] = $item;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\CoreData
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CoreData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get earliestDate value
     * @return string|null
     */
    public function getEarliestDate()
    {
        return $this->earliestDate;
    }
    /**
     * Set earliestDate value
     * @param string $earliestDate
     * @return \StructType\CoreData
     */
    public function setEarliestDate($earliestDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDate) && !is_string($earliestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestDate, true), gettype($earliestDate)), __LINE__);
        }
        $this->earliestDate = $earliestDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\CoreData
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coreDataExtensionsItem) {
            // validation for constraint: itemType
            if (!$coreDataExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($coreDataExtensionsItem) ? get_class($coreDataExtensionsItem) : sprintf('%s(%s)', gettype($coreDataExtensionsItem), var_export($coreDataExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\CoreData
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\CoreData
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get orderingCustomer value
     * @return string|null
     */
    public function getOrderingCustomer()
    {
        return $this->orderingCustomer;
    }
    /**
     * Set orderingCustomer value
     * @param string $orderingCustomer
     * @return \StructType\CoreData
     */
    public function setOrderingCustomer($orderingCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($orderingCustomer) && !is_string($orderingCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderingCustomer, true), gettype($orderingCustomer)), __LINE__);
        }
        $this->orderingCustomer = $orderingCustomer;
        return $this;
    }
    /**
     * Get organizationalUnitId value
     * @return string|null
     */
    public function getOrganizationalUnitId()
    {
        return $this->organizationalUnitId;
    }
    /**
     * Set organizationalUnitId value
     * @param string $organizationalUnitId
     * @return \StructType\CoreData
     */
    public function setOrganizationalUnitId($organizationalUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationalUnitId) && !is_string($organizationalUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationalUnitId, true), gettype($organizationalUnitId)), __LINE__);
        }
        $this->organizationalUnitId = $organizationalUnitId;
        return $this;
    }
    /**
     * Get parentBusinessEvent value
     * @return string|null
     */
    public function getParentBusinessEvent()
    {
        return $this->parentBusinessEvent;
    }
    /**
     * Set parentBusinessEvent value
     * @param string $parentBusinessEvent
     * @return \StructType\CoreData
     */
    public function setParentBusinessEvent($parentBusinessEvent = null)
    {
        // validation for constraint: string
        if (!is_null($parentBusinessEvent) && !is_string($parentBusinessEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentBusinessEvent, true), gettype($parentBusinessEvent)), __LINE__);
        }
        $this->parentBusinessEvent = $parentBusinessEvent;
        return $this;
    }
    /**
     * Get priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param int $priority
     * @return \StructType\CoreData
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get referentialData value
     * @return \StructType\ReferentialData|null
     */
    public function getReferentialData()
    {
        return $this->referentialData;
    }
    /**
     * Set referentialData value
     * @param \StructType\ReferentialData $referentialData
     * @return \StructType\CoreData
     */
    public function setReferentialData(\StructType\ReferentialData $referentialData = null)
    {
        $this->referentialData = $referentialData;
        return $this;
    }
    /**
     * Get serviceOrder value
     * @return \StructType\ServiceOrder|null
     */
    public function getServiceOrder()
    {
        return $this->serviceOrder;
    }
    /**
     * Set serviceOrder value
     * @param \StructType\ServiceOrder $serviceOrder
     * @return \StructType\CoreData
     */
    public function setServiceOrder(\StructType\ServiceOrder $serviceOrder = null)
    {
        $this->serviceOrder = $serviceOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoreData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
