<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEventType StructType
 * @subpackage Structs
 */
class BusinessEventType extends AbstractStructBase
{
    /**
     * The duration
     * @var int
     */
    public $duration;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The skills
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Skill[]
     */
    public $skills;
    /**
     * Constructor method for businessEventType
     * @uses BusinessEventType::setDuration()
     * @uses BusinessEventType::setExtensions()
     * @uses BusinessEventType::setId()
     * @uses BusinessEventType::setSkills()
     * @param int $duration
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $id
     * @param \StructType\Skill[] $skills
     */
    public function __construct($duration = null, array $extensions = array(), $id = null, array $skills = array())
    {
        $this
            ->setDuration($duration)
            ->setExtensions($extensions)
            ->setId($id)
            ->setSkills($skills);
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\BusinessEventType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtensions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionsForArrayConstraintsFromSetExtensions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventTypeExtensionsItem) {
            // validation for constraint: itemType
            if (!$businessEventTypeExtensionsItem instanceof \StructType\WsValuedEntry) {
                $invalidValues[] = is_object($businessEventTypeExtensionsItem) ? get_class($businessEventTypeExtensionsItem) : sprintf('%s(%s)', gettype($businessEventTypeExtensionsItem), var_export($businessEventTypeExtensionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\BusinessEventType
     */
    public function setExtensions(array $extensions = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionsArrayErrorMessage = self::validateExtensionsForArrayConstraintsFromSetExtensions($extensions))) {
            throw new \InvalidArgumentException($extensionsArrayErrorMessage, __LINE__);
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\BusinessEventType
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of type \StructType\WsValuedEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\BusinessEventType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get skills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Skill[]|null
     */
    public function getSkills()
    {
        return isset($this->skills) ? $this->skills : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSkills method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkills method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkillsForArrayConstraintsFromSetSkills(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $businessEventTypeSkillsItem) {
            // validation for constraint: itemType
            if (!$businessEventTypeSkillsItem instanceof \StructType\Skill) {
                $invalidValues[] = is_object($businessEventTypeSkillsItem) ? get_class($businessEventTypeSkillsItem) : sprintf('%s(%s)', gettype($businessEventTypeSkillsItem), var_export($businessEventTypeSkillsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The skills property can only contain items of type \StructType\Skill, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set skills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Skill[] $skills
     * @return \StructType\BusinessEventType
     */
    public function setSkills(array $skills = array())
    {
        // validation for constraint: array
        if ('' !== ($skillsArrayErrorMessage = self::validateSkillsForArrayConstraintsFromSetSkills($skills))) {
            throw new \InvalidArgumentException($skillsArrayErrorMessage, __LINE__);
        }
        if (is_null($skills) || (is_array($skills) && empty($skills))) {
            unset($this->skills);
        } else {
            $this->skills = $skills;
        }
        return $this;
    }
    /**
     * Add item to skills value
     * @throws \InvalidArgumentException
     * @param \StructType\Skill $item
     * @return \StructType\BusinessEventType
     */
    public function addToSkills(\StructType\Skill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Skill) {
            throw new \InvalidArgumentException(sprintf('The skills property can only contain items of type \StructType\Skill, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->skills[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEventType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
