<?php

namespace EnumType;

/**
 * This class stands for urlType EnumType
 * @subpackage Enumerations
 */
class UrlType
{
    /**
     * Constant for value 'BROWSER'
     * @return string 'BROWSER'
     */
    const VALUE_BROWSER = 'BROWSER';
    /**
     * Constant for value 'BUSINESS'
     * @return string 'BUSINESS'
     */
    const VALUE_BUSINESS = 'BUSINESS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BROWSER
     * @uses self::VALUE_BUSINESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BROWSER,
            self::VALUE_BUSINESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
