<?php

namespace EnumType;

/**
 * This class stands for type EnumType
 * @subpackage Enumerations
 */
class Type
{
    /**
     * Constant for value 'PHONE'
     * @return string 'PHONE'
     */
    const VALUE_PHONE = 'PHONE';
    /**
     * Constant for value 'MOBILE'
     * @return string 'MOBILE'
     */
    const VALUE_MOBILE = 'MOBILE';
    /**
     * Constant for value 'EMAIL'
     * @return string 'EMAIL'
     */
    const VALUE_EMAIL = 'EMAIL';
    /**
     * Constant for value 'FAX'
     * @return string 'FAX'
     */
    const VALUE_FAX = 'FAX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_FAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHONE,
            self::VALUE_MOBILE,
            self::VALUE_EMAIL,
            self::VALUE_FAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
